/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.engrave;

import com.yuushya.modelling.Yuushya;
import com.yuushya.modelling.gui.engrave.EngraveBlockResult;
import com.yuushya.modelling.network.TransformDataListPacket;
import com.yuushya.modelling.utils.ShareUtils;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;

public class EngraveBlockResultLoader {
    public static final Path PATH = Platform.getModsFolder().resolve("../modellings/blocks");
    public static final Map<String, EngraveBlockResult> SHOWBLOCK_ITEM_MAP = new HashMap<String, EngraveBlockResult>();

    public static void load(ClientLevel level) {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                EngraveBlockResultLoader.load(PATH, level);
            }
            catch (IOException e) {
                Yuushya.LOGGER.error((Object)e);
            }
        }
    }

    public static boolean isZip(Path basePath) {
        return basePath.toString().endsWith(".zip");
    }

    private static void loadZip(Path path, ClientLevel level) {
        try (FileSystem fileSystem = FileSystems.newFileSystem(path);){
            EngraveBlockResultLoader.load(fileSystem.getPath(".", new String[0]), level);
        }
        catch (IOException e) {
            Yuushya.LOGGER.error((Object)e);
        }
    }

    private static void load(final Path path, final ClientLevel level) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (EngraveBlockResultLoader.isZip(file)) {
                    EngraveBlockResultLoader.loadZip(file, level);
                } else if (file.getFileName().toString().endsWith(".json")) {
                    String name = path.relativize(file).toString().replaceAll(".json", "");
                    String fileString = Files.readString(file);
                    try {
                        ShareUtils.ShareBlockInformation information = ShareUtils.from(fileString);
                        SHOWBLOCK_ITEM_MAP.put(name, new EngraveBlockResult(name, information, level));
                    }
                    catch (Exception e) {
                        Yuushya.LOGGER.error((Object)e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void saveBlock(String string, String name) throws IOException {
        ShareUtils.ShareBlockInformation information = ShareUtils.from(string);
        SHOWBLOCK_ITEM_MAP.put(name, new EngraveBlockResult(name, information));
        TransformDataListPacket.updateSendingCache(name);
        Path out = PATH.resolve("./" + name + ".json");
        if (!Files.exists(out, new LinkOption[0])) {
            if (!Files.exists(out.getParent(), new LinkOption[0])) {
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
            }
            Files.createFile(out, new FileAttribute[0]);
        }
        if (Files.exists(out, new LinkOption[0])) {
            Files.writeString(out, (CharSequence)string, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }
}

