/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.engrave;

import com.yuushya.modelling.Yuushya;
import com.yuushya.modelling.gui.engrave.EngraveItemResult;
import com.yuushya.modelling.network.TransformDataListPacket;
import com.yuushya.modelling.utils.ShareUtils;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;

public class EngraveItemResultLoader {
    public static final Path PATH = Platform.getModsFolder().resolve("../modellings/items");
    public static final Map<String, EngraveItemResult> ITEMBLOCK_ITEM_MAP = new HashMap<String, EngraveItemResult>();

    public static void load(ClientLevel level) {
        if (Files.exists(PATH, new LinkOption[0])) {
            try {
                EngraveItemResultLoader.load(PATH, level);
            }
            catch (IOException e) {
                Yuushya.LOGGER.error((Object)e);
            }
        }
    }

    public static boolean isZip(Path basePath) {
        return basePath.toString().endsWith(".zip");
    }

    private static void loadZip(Path path, ClientLevel level) {
        try (FileSystem fileSystem = FileSystems.newFileSystem(path);){
            EngraveItemResultLoader.load(fileSystem.getPath(".", new String[0]), level);
        }
        catch (IOException e) {
            Yuushya.LOGGER.error((Object)e);
        }
    }

    private static void load(final Path path, final ClientLevel level) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (EngraveItemResultLoader.isZip(file)) {
                    EngraveItemResultLoader.loadZip(file, level);
                } else if (file.getFileName().toString().endsWith(".json")) {
                    String name = path.relativize(file).toString().replaceAll(".json", "");
                    String fileString = Files.readString(file);
                    try {
                        ShareUtils.ShareItemInformation information = ShareUtils.fromItems(fileString);
                        ITEMBLOCK_ITEM_MAP.put(name, new EngraveItemResult(name, information, level));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void saveItem(String string, String name) throws IOException {
        ShareUtils.ShareItemInformation information = ShareUtils.fromItems(string);
        ITEMBLOCK_ITEM_MAP.put(name, new EngraveItemResult(name, information));
        TransformDataListPacket.updateSendingCache(name);
        Path out = PATH.resolve("./" + name + ".json");
        if (!Files.exists(out, new LinkOption[0])) {
            if (!Files.exists(out.getParent(), new LinkOption[0])) {
                Files.createDirectories(out.getParent(), new FileAttribute[0]);
            }
            Files.createFile(out, new FileAttribute[0]);
        }
        if (Files.exists(out, new LinkOption[0])) {
            Files.writeString(out, (CharSequence)string, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }
}

