/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.itemblock;

import com.yuushya.modelling.Yuushya;
import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import com.yuushya.modelling.gui.engrave.EngraveItemResultLoader;
import com.yuushya.modelling.gui.showblock.EditScreen;
import com.yuushya.modelling.gui.validate.DividedDoubleRange;
import com.yuushya.modelling.gui.validate.DoubleRange;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.widget.ColorWidget;
import com.yuushya.modelling.gui.widget.ItemStackIconList;
import com.yuushya.modelling.gui.widget.ItemTransformComponent;
import com.yuushya.modelling.gui.widget.SizeTransformComponent;
import com.yuushya.modelling.item.showblocktool.PosTransItem;
import com.yuushya.modelling.network.ItemStackPacket;
import com.yuushya.modelling.network.ItemTransformDataOncePacket;
import com.yuushya.modelling.network.UpdateAOPacket;
import com.yuushya.modelling.utils.ShareUtils;
import com.yuushya.modelling.utils.YuushyaUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ItemBlockScreen
extends Screen {
    public static final int PER_HEIGHT = 20;
    public static final int SMALL_BUTTON_WIDTH = 10;
    private static final int TOP = 10;
    private static final int RIGHT_COLUMN_X = 2;
    private static final int RIGHT_BAR_WIDTH = 20;
    private static final int RIGHT_LIST_WIDTH = 40;
    private static final int RIGHT_LIST_PER_HEIGHT = 45;
    private static final int RIGHT_LIST_TOP = 35;
    private static final int RIGHT_LIST_HEIGHT = 137;
    private static final int RIGHT_LIST_BOTTOM = 172;
    private static final int RIGHT_STATE_PANEL_Y = 177;
    private static final int RIGHT_STATE_INFORM_X = 45;
    private final ItemBlockEntity blockEntity;
    private final ItemStack newItemStack;
    private final Map<ItemTransformType, Double> storage = new HashMap<ItemTransformType, Double>();
    private final Map<ItemTransformType, ItemTransformComponent> panel = new LinkedHashMap<ItemTransformType, ItemTransformComponent>();
    private final Map<ItemTransformType, SizeTransformComponent> panelSize = new LinkedHashMap<ItemTransformType, SizeTransformComponent>();
    public EditBox colorEditBox;
    public Button colorFinishButton;
    public CycleButton<ApplyColor> colorApplyButton;
    private int slot;
    private ItemStack itemStack = ItemStack.EMPTY;
    private CycleButton<Mode> modeButton;
    private CycleButton<Boolean> shownStateButton;
    private ItemStackIconList itemStackList;
    private ColorWidget colorWidget;

    public ItemBlockScreen(ItemBlockEntity blockEntity, ItemStack newItemStack) {
        super(GameNarrator.NO_TITLE);
        this.blockEntity = blockEntity;
        this.newItemStack = newItemStack;
        if (blockEntity.getSlot() < blockEntity.getTransformData().size()) {
            this.slot = blockEntity.getSlot();
        }
    }

    private static int top(int i, int offset) {
        return 40 + 20 * i + offset;
    }

    public void setSlot(int slot) {
        for (ItemTransformType key : this.storage.keySet()) {
            ItemTransformDataOncePacket.sendToServerSide(this.blockEntity.getBlockPos(), this.slot, key, this.storage.get((Object)key));
        }
        if (!this.itemStack.isEmpty()) {
            NetworkManager.sendToServer((CustomPacketPayload)new ItemStackPacket(this.blockEntity.getBlockPos(), this.slot, this.itemStack));
        }
        this.itemStack = ItemStack.EMPTY;
        this.storage.clear();
        this.slot = slot;
        this.blockEntity.setSlot(slot);
        for (ItemTransformComponent component : this.panel.values()) {
            component.setSliderInitial(this.blockEntity, this.slot);
        }
        for (SizeTransformComponent size : this.panelSize.values()) {
            size.setSliderInitial(this.blockEntity, this.slot);
        }
        double extract = ItemTransformType.COLOR.extract(this.blockEntity, slot);
        this.colorWidget.setColor((int)extract);
        this.colorEditBox.setValue(String.format("#%06X", 0xFFFFFF & (int)extract));
        this.shownStateButton.setValue((Object)this.blockEntity.getTransformData((int)slot).isShown);
    }

    private ItemTransformComponent choose(ItemTransformType type) {
        return this.panel.computeIfAbsent(type, ItemTransformComponent::new);
    }

    private SizeTransformComponent chooseSize(ItemTransformType type) {
        return this.panelSize.computeIfAbsent(type, SizeTransformComponent::new);
    }

    private void updateColorVisible(boolean visible) {
        this.colorWidget.visible = visible;
        this.colorEditBox.visible = visible;
        this.colorFinishButton.visible = visible;
        this.colorApplyButton.visible = visible;
    }

    public ItemStack getItemStack() {
        return this.blockEntity.getTransformData((int)this.slot).itemStack;
    }

    private int leftColumnX() {
        return this.width / 4 * 3 + 10;
    }

    private int leftColumnWidth() {
        return this.width / 4 - 20;
    }

    protected void init() {
        if (this.minecraft == null) {
            return;
        }
        Button addItemButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
            if (this.newItemStack != null) {
                if (this.newItemStack.isEmpty()) {
                    return;
                }
                this.itemStackList.addSlot();
                this.updateItemStack(this.newItemStack);
                this.updateTransformDataClient(ItemTransformType.SHOWN, 1.0);
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.add"))).bounds(2, 10, 20, 20).build();
        Button copyItemButton = Button.builder((Component)Component.literal((String)"\u29c9"), btn -> {
            ItemStackIconList.Entry selected = (ItemStackIconList.Entry)this.itemStackList.getSelected();
            if (selected != null) {
                this.itemStackList.addSlot();
                this.updateTransformDataClient(selected.getTransformData());
                this.itemStackList.setSelectedSlot(this.slot);
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.copy"))).bounds(22, 10, 20, 20).build();
        Button removeItemButton = Button.builder((Component)Component.literal((String)"\u00d7"), btn -> this.updateTransformDataClient(ItemTransformType.REMOVE, 0.0)).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.remove"))).bounds(42, 10, 20, 20).build();
        Button replaceButton = Button.builder((Component)Component.literal((String)"\u21c4"), btn -> {
            int chosen = this.itemStackList.getChosenOne();
            if (chosen != -1 && chosen != this.slot) {
                ItemStack item = this.blockEntity.getTransformData((int)chosen).itemStack;
                if (item == null) {
                    return;
                }
                if (item.isEmpty()) {
                    return;
                }
                this.updateItemStack(item);
            } else if (this.newItemStack != null) {
                if (this.newItemStack.isEmpty()) {
                    return;
                }
                this.updateItemStack(this.newItemStack);
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.replace"))).bounds(62, 10, 20, 20).build();
        this.shownStateButton = CycleButton.booleanBuilder((Component)Component.literal((String)"\ud83d\udd76"), (Component)Component.literal((String)"\ud83d\udc40")).displayOnlyValue().withInitialValue((Object)true).withTooltip(on -> Tooltip.create((Component)(on != false ? Component.translatable((String)"gui.showBlockScreen.display.on") : Component.translatable((String)"gui.showBlockScreen.display.off")))).create(82, 10, 20, 20, (Component)Component.empty(), (btn, bl) -> this.updateTransformDataClient(ItemTransformType.SHOWN, bl != false ? 1.0 : 0.0));
        Button copyButton = Button.builder((Component)Component.literal((String)"\ud83d\udce4").withStyle(ChatFormatting.BOLD), btn -> {
            String res = ShareUtils.transferItems(this.blockEntity.getTransformData());
            ItemBlockScreen.setClipboard(res);
            this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.copy_pass"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.share_hint")));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.copy"))).bounds(122, 10, 20, 20).build();
        Button parseButton = Button.builder((Component)Component.literal((String)"\ud83d\udce5").withStyle(ChatFormatting.BOLD), btn -> {
            String string = this.getClipboard();
            try {
                ShareUtils.ShareItemInformation shareInformation = ShareUtils.fromItems(string);
                if (shareInformation.items().isEmpty()) {
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.error"), (Component)Component.literal((String)"No item data found")));
                    return;
                }
                this.checkModLack(shareInformation);
                this.updateAllTransformData(shareInformation);
                this.minecraft.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.paste_pass"), null));
            }
            catch (Exception e) {
                this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.error"), (Component)Component.literal((String)e.getMessage())));
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.paste"))).bounds(142, 10, 20, 20).build();
        Button saveButton = Button.builder((Component)Component.literal((String)"\ud83d\udcbe").withStyle(ChatFormatting.BOLD), btn -> this.minecraft.setScreen((Screen)new EditScreen(this, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save.tip"), string -> {
            if (string != null) {
                String res = ShareUtils.transferItems(this.blockEntity.getTransformData());
                try {
                    EngraveItemResultLoader.saveItem(res, string);
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save_pass"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.share_hint")));
                }
                catch (IOException e) {
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save_error"), (Component)Component.literal((String)e.getMessage())));
                }
                this.minecraft.setScreen((Screen)this);
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, string -> true))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.save"))).bounds(162, 10, 20, 20).build();
        CycleButton ambientOcclusionButton = CycleButton.booleanBuilder((Component)Component.literal((String)"\u25cf"), (Component)Component.literal((String)"\u2600")).displayOnlyValue().withInitialValue((Object)((Boolean)this.blockEntity.getBlockState().getValue((Property)AbstractTransformBlock.ENABLE_AO))).withTooltip(on -> Tooltip.create((Component)(on != false ? Component.translatable((String)"gui.itemBlockScreen.ambientOcclusion.off") : Component.translatable((String)"gui.itemBlockScreen.ambientOcclusion.on")))).create(182, 10, 20, 20, (Component)Component.empty(), (btn, enableAO) -> {
            Level level = this.blockEntity.getLevel();
            if (level != null) {
                NetworkManager.sendToServer((CustomPacketPayload)new UpdateAOPacket((boolean)enableAO, this.blockEntity.getBlockPos()));
            }
        });
        Button xMirror = Button.builder((Component)Component.literal((String)"x"), button -> this.mirror(YuushyaUtils.MirrorFace.X)).bounds(2, 177, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.itemBlockScreen.mirror.tip", (Object[])new Object[]{"X"}))).build();
        Button yMirror = Button.builder((Component)Component.literal((String)"y"), button -> this.mirror(YuushyaUtils.MirrorFace.Y)).bounds(22, 177, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.itemBlockScreen.mirror.tip", (Object[])new Object[]{"Y"}))).build();
        Button zMirror = Button.builder((Component)Component.literal((String)"z"), button -> this.mirror(YuushyaUtils.MirrorFace.Z)).bounds(42, 177, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.itemBlockScreen.mirror.tip", (Object[])new Object[]{"Z"}))).build();
        this.itemStackList = new ItemStackIconList(this.minecraft, 40, 137, 2, 35, 40, 45, this.blockEntity.getTransformData(), this);
        CycleButton shapeButton = CycleButton.builder(BlockShape::getSymbol).displayOnlyValue().withValues((Object[])BlockShape.values()).withInitialValue((Object)ItemTransformType.SHAPE.extractShape(this.blockEntity)).create(this.leftColumnX() - 50, 10, 40, 20, (Component)Component.literal((String)"shape"), (button, shape) -> this.updateTransformDataClient(ItemTransformType.SHAPE, Double.valueOf(shape.ordinal())));
        this.modeButton = CycleButton.builder(Mode::getSymbol).displayOnlyValue().withValues((Object[])Mode.values()).withInitialValue((Object)Mode.SLIDER).withTooltip(mode -> Tooltip.create((Component)(switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"gui.itemBlockScreen.mode.slider.tooltip");
            case 1 -> Component.translatable((String)"gui.itemBlockScreen.mode.fine_tune.tooltip");
            case 2 -> Component.translatable((String)"gui.itemBlockScreen.mode.edit.tooltip");
            case 3 -> Component.translatable((String)"gui.showBlockScreen.mode.color.tooltip");
            case 4 -> Component.translatable((String)"gui.itemBlockScreen.mode.custom_size.tooltip");
        }))).create(this.leftColumnX(), 10, this.leftColumnWidth(), 20, (Component)Component.literal((String)"MODE"), (btn, mode) -> {
            switch (mode.ordinal()) {
                case 0: {
                    this.panel.values().forEach(ItemTransformComponent::setSliderStep);
                    break;
                }
                case 1: 
                case 2: {
                    this.panel.values().forEach(ItemTransformComponent::setSliderFineTune);
                }
            }
            switch (mode.ordinal()) {
                case 0: 
                case 1: {
                    this.panel.values().forEach(it -> it.triggerVisible(true));
                    this.panelSize.values().forEach(it -> it.triggerVisible(false));
                    this.updateColorVisible(false);
                    break;
                }
                case 2: {
                    this.panel.values().forEach(it -> it.triggerVisible(false));
                    this.panelSize.values().forEach(it -> it.triggerVisible(false));
                    this.updateColorVisible(false);
                    break;
                }
                case 3: {
                    this.panel.values().forEach(ItemTransformComponent::setInvisible);
                    this.panelSize.values().forEach(it -> it.triggerVisible(false));
                    this.updateColorVisible(true);
                    break;
                }
                case 4: {
                    this.panel.values().forEach(ItemTransformComponent::setInvisible);
                    this.panelSize.values().forEach(it -> it.triggerVisible(true));
                    this.updateColorVisible(false);
                }
            }
        });
        this.choose(ItemTransformType.SCALE_X);
        double posX = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.x()), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.x()));
        this.choose((ItemTransformType)ItemTransformType.POS_X).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.pos_text"), () -> -posX, () -> posX, () -> PosTransItem.getStep(posX), number -> this.updateTransformDataClient(ItemTransformType.POS_X, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.DARK_RED))).step(this.choose(ItemTransformType.POS_X).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowPosAxis();
        }).initial(ItemTransformType.POS_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(0, 0), this.leftColumnWidth(), 20).build();
        double posY = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.y()), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.y()));
        this.choose((ItemTransformType)ItemTransformType.POS_Y).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.pos_text"), () -> -posY, () -> posY, () -> PosTransItem.getStep(posY), number -> this.updateTransformDataClient(ItemTransformType.POS_Y, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.GREEN))).step(this.choose(ItemTransformType.POS_Y).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowPosAxis();
        }).initial(ItemTransformType.POS_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(1, 0), this.leftColumnWidth(), 20).build();
        double posZ = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.z()), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.z()));
        this.choose((ItemTransformType)ItemTransformType.POS_Z).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.pos_text"), () -> -posZ, () -> posZ, () -> PosTransItem.getStep(posZ), number -> this.updateTransformDataClient(ItemTransformType.POS_Z, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.BLUE))).step(this.choose(ItemTransformType.POS_Z).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowPosAxis();
        }).initial(ItemTransformType.POS_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(2, 0), this.leftColumnWidth(), 20).build();
        this.choose((ItemTransformType)ItemTransformType.ROT_X).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformDataClient(ItemTransformType.ROT_X, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.DARK_RED))).step(this.choose(ItemTransformType.ROT_X).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowRotAxis();
        }).initial(ItemTransformType.ROT_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(3, 10), this.leftColumnWidth(), 20).build();
        this.choose((ItemTransformType)ItemTransformType.ROT_Y).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformDataClient(ItemTransformType.ROT_Y, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.GREEN))).step(this.choose(ItemTransformType.ROT_Y).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowRotAxis();
        }).initial(ItemTransformType.ROT_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(4, 10), this.leftColumnWidth(), 20).build();
        this.choose((ItemTransformType)ItemTransformType.ROT_Z).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformDataClient(ItemTransformType.ROT_Z, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.itemblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.BLUE))).step(this.choose(ItemTransformType.ROT_Z).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowRotAxis();
        }).initial(ItemTransformType.ROT_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(5, 10), this.leftColumnWidth(), 20).build();
        this.choose((ItemTransformType)ItemTransformType.SCALE_X).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.empty(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformDataClient(ItemTransformType.SCALE_X, (Double)number);
            this.updateTransformDataClient(ItemTransformType.SCALE_Y, (Double)number);
            this.updateTransformDataClient(ItemTransformType.SCALE_Z, (Double)number);
            this.choose((ItemTransformType)ItemTransformType.POS_X).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_X).sliderButton.getValidatedValue());
            this.choose((ItemTransformType)ItemTransformType.POS_Y).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_Y).sliderButton.getValidatedValue());
            this.choose((ItemTransformType)ItemTransformType.POS_Z).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_Z).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.translatable((String)"gui.yuushya.itemBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.choose(ItemTransformType.SCALE_X).setStandardStep(0.1)).initial(ItemTransformType.SCALE_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(6, 20), this.leftColumnWidth(), 20).build();
        this.choose((ItemTransformType)ItemTransformType.LIT).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.brightness_text"), 0.0, 15.0, number -> this.updateTransformDataClient(ItemTransformType.LIT, (Double)number)).text(LazyDoubleRange::captionToString).step(this.choose(ItemTransformType.LIT).setStandardStep(1.0)).initial(ItemTransformType.LIT.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(7, 30), this.leftColumnWidth(), 20).build();
        this.chooseSize((ItemTransformType)ItemTransformType.SCALE_X).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.empty(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformDataClient(ItemTransformType.SCALE_X, (Double)number);
            this.chooseSize((ItemTransformType)ItemTransformType.SCALE_X).editBox.setValue(String.valueOf(number));
            this.choose((ItemTransformType)ItemTransformType.POS_X).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_X).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.translatable((String)"gui.yuushya.itemBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.chooseSize(ItemTransformType.SCALE_X).setStandardStep(0.1)).initial(ItemTransformType.SCALE_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(0, 20), this.leftColumnWidth(), 20).build();
        this.chooseSize((ItemTransformType)ItemTransformType.SCALE_Y).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.empty(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformDataClient(ItemTransformType.SCALE_Y, (Double)number);
            this.chooseSize((ItemTransformType)ItemTransformType.SCALE_Y).editBox.setValue(String.valueOf(number));
            this.choose((ItemTransformType)ItemTransformType.POS_Y).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_Y).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.translatable((String)"gui.yuushya.itemBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.chooseSize(ItemTransformType.SCALE_Y).setStandardStep(0.1)).initial(ItemTransformType.SCALE_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(2, 20), this.leftColumnWidth(), 20).build();
        this.chooseSize((ItemTransformType)ItemTransformType.SCALE_Z).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.empty(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformDataClient(ItemTransformType.SCALE_Z, (Double)number);
            this.chooseSize((ItemTransformType)ItemTransformType.SCALE_Z).editBox.setValue(String.valueOf(number));
            this.choose((ItemTransformType)ItemTransformType.POS_Z).sliderButton.setValidatedValue(this.choose((ItemTransformType)ItemTransformType.POS_Z).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.translatable((String)"gui.yuushya.itemBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.chooseSize(ItemTransformType.SCALE_Z).setStandardStep(0.1)).initial(ItemTransformType.SCALE_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ItemBlockScreen.top(4, 20), this.leftColumnWidth(), 20).build();
        this.colorWidget = new ColorWidget(this.leftColumnX() - 10, ItemBlockScreen.top(-2, 30), 110, 160, (int)ItemTransformType.COLOR.extract(this.blockEntity, this.slot), (Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.color_text"), this);
        this.colorEditBox = new EditBox(this.font, this.leftColumnX() - 5, ItemBlockScreen.top(6, 30), this.leftColumnWidth(), 20, (Component)Component.translatable((String)"gui.yuushya.itemBlockScreen.color_text"));
        this.colorEditBox.setMaxLength(7);
        this.colorFinishButton = Button.builder((Component)Component.literal((String)"\u221a").withStyle(ChatFormatting.GREEN), button -> {
            String text = this.colorEditBox.getValue();
            if (text.startsWith("#")) {
                try {
                    int color = Integer.parseInt(text.substring(1), 16);
                    this.colorWidget.setColor(color);
                    this.updateTransformDataClient(ItemTransformType.COLOR, Double.valueOf(color));
                }
                catch (NumberFormatException ignored) {
                    Yuushya.LOGGER.error("Invalid color number");
                }
            }
        }).bounds(this.leftColumnX() + this.leftColumnWidth() - 5, ItemBlockScreen.top(6, 30), 10, 20).build();
        this.colorApplyButton = CycleButton.builder(ApplyColor::getSymbol).displayOnlyValue().withValues((Object[])ApplyColor.values()).withInitialValue((Object)ApplyColor.PRE_APPLY).withTooltip(mode -> Tooltip.create((Component)mode.getDescription())).create(this.leftColumnX() + 30, ItemBlockScreen.top(-2, 30) + 5, 50, 20, (Component)Component.literal((String)"TYPE"), (button, mode) -> {
            switch (mode.ordinal()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    int color = (int)ItemTransformType.COLOR.extract(this.blockEntity, this.slot);
                    for (int i = 0; i < this.blockEntity.getTransformData().size(); ++i) {
                        if (i == this.slot) continue;
                        this.updateTransformDataSever(ItemTransformType.COLOR, Double.valueOf(color), i);
                    }
                    this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
                    this.colorApplyButton.setValue((Object)ApplyColor.PRE_APPLY);
                }
            }
        });
        this.colorWidget.visible = false;
        this.colorEditBox.visible = false;
        this.colorFinishButton.visible = false;
        this.colorApplyButton.visible = false;
        for (ItemTransformComponent component : this.panel.values()) {
            component.initWidget(this.font);
            this.addRenderableWidget((GuiEventListener)component.sliderButton);
            this.addRenderableWidget((GuiEventListener)component.minusButton);
            this.addRenderableWidget((GuiEventListener)component.addButton);
            this.addRenderableWidget((GuiEventListener)component.editBox);
            this.addRenderableWidget((GuiEventListener)component.cancelButton);
            this.addRenderableWidget((GuiEventListener)component.finishButton);
        }
        for (SizeTransformComponent size : this.panelSize.values()) {
            size.initWidget(this.font);
            this.addRenderableWidget((GuiEventListener)size.sliderButton);
            this.addRenderableWidget((GuiEventListener)size.minusButton);
            this.addRenderableWidget((GuiEventListener)size.addButton);
            this.addRenderableWidget((GuiEventListener)size.editBox);
            this.addRenderableWidget((GuiEventListener)size.cancelButton);
            this.addRenderableWidget((GuiEventListener)size.finishButton);
            size.triggerVisible(false);
        }
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.addRenderableWidget((GuiEventListener)shapeButton);
        this.addWidget((GuiEventListener)this.itemStackList);
        this.addRenderableWidget((GuiEventListener)addItemButton);
        this.addRenderableWidget((GuiEventListener)removeItemButton);
        this.addRenderableWidget((GuiEventListener)copyItemButton);
        this.addRenderableWidget((GuiEventListener)replaceButton);
        this.addRenderableWidget((GuiEventListener)this.shownStateButton);
        this.addRenderableWidget((GuiEventListener)copyButton);
        this.addRenderableWidget((GuiEventListener)parseButton);
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.addRenderableWidget((GuiEventListener)ambientOcclusionButton);
        this.addRenderableWidget((GuiEventListener)xMirror);
        this.addRenderableWidget((GuiEventListener)yMirror);
        this.addRenderableWidget((GuiEventListener)zMirror);
        this.addRenderableWidget((GuiEventListener)this.colorWidget);
        this.addRenderableWidget((GuiEventListener)this.colorEditBox);
        this.addRenderableWidget((GuiEventListener)this.colorFinishButton);
        this.addRenderableWidget((GuiEventListener)this.colorApplyButton);
        this.itemStackList.setSelectedSlot(this.slot);
    }

    private void mirror(YuushyaUtils.MirrorFace face) {
        double x = ItemTransformType.POS_X.extract(this.blockEntity, this.slot);
        double y = ItemTransformType.POS_Y.extract(this.blockEntity, this.slot);
        double z = ItemTransformType.POS_Z.extract(this.blockEntity, this.slot);
        Vector3d pos = new Vector3d(x, y, z);
        double xRot = ItemTransformType.ROT_X.extract(this.blockEntity, this.slot);
        double yRot = ItemTransformType.ROT_Y.extract(this.blockEntity, this.slot);
        double zRot = ItemTransformType.ROT_Z.extract(this.blockEntity, this.slot);
        Quaternionf rot = new Quaternionf().rotateXYZ((float)Math.toRadians(xRot), (float)Math.toRadians(yRot), (float)Math.toRadians(zRot));
        YuushyaUtils.mirror(pos, rot, face);
        this.updateTransformDataClient(ItemTransformType.POS_X, pos.x);
        this.updateTransformDataClient(ItemTransformType.POS_Y, pos.y);
        this.updateTransformDataClient(ItemTransformType.POS_Z, pos.z);
        Vector3f euler = rot.getEulerAnglesXYZ(new Vector3f());
        this.updateTransformDataClient(ItemTransformType.ROT_X, YuushyaUtils.normalizeAngle(Math.toDegrees(euler.x)));
        this.updateTransformDataClient(ItemTransformType.ROT_Y, YuushyaUtils.normalizeAngle(Math.toDegrees(euler.y)));
        this.updateTransformDataClient(ItemTransformType.ROT_Z, YuushyaUtils.normalizeAngle(Math.toDegrees(euler.z)));
        this.itemStackList.setSelectedSlot(this.slot);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.itemStackList.render(guiGraphics, mouseX, mouseY, partialTick);
        ItemStack itemStack = this.getItemStack();
        guiGraphics.drawString(this.font, itemStack.getDisplayName(), 45, 36, -1, false);
        if (this.modeButton.getValue() == Mode.EDIT) {
            for (ItemTransformComponent component : this.panel.values()) {
                guiGraphics.drawString(this.font, component.editBox.getMessage(), component.editBox.getX() + component.editBox.getWidth() / 2, component.editBox.getY() + component.editBox.getHeight() / 3, 0x707070);
                component.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        for (ItemTransformType key : this.storage.keySet()) {
            ItemTransformDataOncePacket.sendToServerSide(this.blockEntity.getBlockPos(), this.slot, key, this.storage.get((Object)key));
        }
        if (!this.itemStack.isEmpty()) {
            NetworkManager.sendToServer((CustomPacketPayload)new ItemStackPacket(this.blockEntity.getBlockPos(), this.slot, this.itemStack));
        }
        this.itemStack = ItemStack.EMPTY;
        this.storage.clear();
        ItemTransformDataOncePacket.sendToServerSideSuccess(this.blockEntity.getBlockPos());
    }

    public void checkModLack(ShareUtils.ShareItemInformation shareInformation) {
        List<String> unLoaded = shareInformation.mods().stream().filter(id -> !Platform.getModIds().contains(id)).toList();
        if (unLoaded.isEmpty()) {
            return;
        }
        if (unLoaded.contains("yuushya")) {
            return;
        }
        Minecraft.getInstance().getToasts().addToast((Toast)SystemToast.multiline((Minecraft)Minecraft.getInstance(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.literal((String)"Mod Lack"), (Component)Component.literal((String)String.join((CharSequence)", ", unLoaded))));
    }

    private void updateAllTransformData(ShareUtils.ShareItemInformation shareInformation) {
        int slot;
        List<TransformItemData> dataList = this.blockEntity.getTransformData();
        BlockPos pos = this.blockEntity.getBlockPos();
        int currentSize = dataList.size();
        for (int slot2 = 0; slot2 < currentSize; ++slot2) {
            this.blockEntity.removeTransformData(slot2);
            ItemTransformDataOncePacket.sendToServerSide(pos, slot2, ItemTransformType.REMOVE, 0.0);
        }
        shareInformation.transferItems(dataList);
        int nextSize = dataList.size();
        this.blockEntity.getLevel().sendBlockUpdated(pos, this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
        this.storage.clear();
        for (slot = 0; slot < nextSize; ++slot) {
            TransformItemData data = dataList.get(slot);
            this.updateTransformDataServerImmediate(data, slot);
        }
        ItemTransformDataOncePacket.sendToServerSideSuccess(pos);
        for (slot = nextSize - 1; slot < currentSize; ++slot) {
            this.blockEntity.setSlot(slot);
        }
        this.itemStackList.updateRenderList();
    }

    private void updateTransformDataServerImmediate(TransformItemData data, int slot) {
        if (data.itemStack.isEmpty()) {
            return;
        }
        BlockPos pos = this.blockEntity.getBlockPos();
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.POS_X, data.pos.x);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.POS_Y, data.pos.y);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.POS_Z, data.pos.z);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.ROT_X, data.rot.x);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.ROT_Y, data.rot.y);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.ROT_Z, data.rot.z);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.SCALE_X, data.scales.x);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.SCALE_Y, data.scales.y);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.SCALE_Z, data.scales.z);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.SHOWN, data.isShown ? 1.0 : 0.0);
        ItemTransformDataOncePacket.sendToServerSide(pos, slot, ItemTransformType.COLOR, data.color);
        NetworkManager.sendToServer((CustomPacketPayload)new ItemStackPacket(pos, slot, data.itemStack));
    }

    private void updateTransformDataClient(TransformItemData data) {
        this.updateTransformDataClient(ItemTransformType.POS_X, data.pos.x);
        this.updateTransformDataClient(ItemTransformType.POS_Y, data.pos.y);
        this.updateTransformDataClient(ItemTransformType.POS_Z, data.pos.z);
        this.updateTransformDataClient(ItemTransformType.ROT_X, Double.valueOf(data.rot.x));
        this.updateTransformDataClient(ItemTransformType.ROT_Y, Double.valueOf(data.rot.y));
        this.updateTransformDataClient(ItemTransformType.ROT_Z, Double.valueOf(data.rot.z));
        this.updateTransformDataClient(ItemTransformType.SCALE_X, Double.valueOf(data.scales.x));
        this.updateTransformDataClient(ItemTransformType.SCALE_Y, Double.valueOf(data.scales.y));
        this.updateTransformDataClient(ItemTransformType.SCALE_Z, Double.valueOf(data.scales.z));
        this.updateTransformDataClient(ItemTransformType.SHOWN, data.isShown ? 1.0 : 0.0);
        this.updateTransformDataClient(ItemTransformType.COLOR, Double.valueOf(data.color));
        this.updateItemStack(data.itemStack);
    }

    public void updateTransformDataClient(ItemTransformType type, Double number) {
        this.storage.put(type, number);
        type.modify(this.blockEntity, this.slot, number);
        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
    }

    public void updateTransformDataSever(ItemTransformType type, Double number, int slot) {
        type.modify(this.blockEntity, slot, number);
        ItemTransformDataOncePacket.sendToServerSide(this.blockEntity.getBlockPos(), slot, type, number);
    }

    private void updateItemStack(ItemStack itemStack) {
        this.itemStack = itemStack.copy();
        ItemTransformType.ITEM_STACK.modify(this.blockEntity, this.slot, itemStack);
        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    public static void setClipboard(String clipboardValue) {
        Minecraft mc = Minecraft.getInstance();
        TextFieldHelper.setClipboardContents((Minecraft)mc, (String)clipboardValue);
    }

    public Font getFont() {
        return this.font;
    }

    public static enum Mode implements StringRepresentable
    {
        SLIDER("slider"),
        FINE_TUNE("fine_tune"),
        EDIT("edit"),
        COLOR("color"),
        CUSTOM_SIZE("custom_size");

        private final String name;
        private final Component symbol;

        private Mode(String name) {
            this.name = name;
            this.symbol = Component.translatable((String)("gui.itemBlockScreen.mode." + name));
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Generated
        public Component getSymbol() {
            return this.symbol;
        }
    }

    public static enum ApplyColor {
        PRE_APPLY,
        APPLY,
        DONE;


        public Component getSymbol() {
            return Component.translatable((String)("gui.itemBlockScreen.apply." + this.name().toLowerCase()));
        }

        public Component getDescription() {
            return Component.translatable((String)("gui.itemBlockScreen.apply.tip." + this.name().toLowerCase()));
        }
    }
}

