/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.showblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.BlockShape;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.blockentity.transformData.TransformType;
import com.yuushya.modelling.gui.engrave.EngraveBlockResultLoader;
import com.yuushya.modelling.gui.showblock.EditScreen;
import com.yuushya.modelling.gui.validate.DividedDoubleRange;
import com.yuushya.modelling.gui.validate.DoubleRange;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.widget.BlockStateIconList;
import com.yuushya.modelling.gui.widget.TransformComponent;
import com.yuushya.modelling.item.YuushyaDebugStickItem;
import com.yuushya.modelling.item.showblocktool.PosTransItem;
import com.yuushya.modelling.network.TransformDataOncePacket;
import com.yuushya.modelling.utils.ShareUtils;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ShowBlockScreen
extends Screen {
    public static final int PER_HEIGHT = 20;
    public static final int SMALL_BUTTON_WIDTH = 10;
    private static final int TOP = 10;
    private static final int RIGHT_COLUMN_X = 2;
    private static final int RIGHT_BAR_WIDTH = 20;
    private static final int RIGHT_LIST_WIDTH = 40;
    private static final int RIGHT_LIST_PER_HEIGHT = 45;
    private static final int RIGHT_LIST_TOP = 35;
    private static final int RIGHT_LIST_HEIGHT = 137;
    private static final int RIGHT_LIST_BOTTOM = 172;
    private static final int RIGHT_STATE_PANEL_Y = 177;
    private static final int RIGHT_STATE_INFORM_X = 45;
    private final ShowBlockEntity blockEntity;
    private final BlockState newBlockState;
    private final Map<TransformType, Double> storage = new HashMap<TransformType, Double>();
    private final Map<TransformType, TransformComponent> panel = new LinkedHashMap<TransformType, TransformComponent>();
    private final Map<TransformType, EditBox> editBoxes = new HashMap<TransformType, EditBox>();
    private int slot;
    private CycleButton<Mode> modeButton;
    private CycleButton<Boolean> shownStateButton;
    private BlockStateIconList blockStateList;
    private Button leftPropertyButton;
    private Property<?> property;
    private Button rightPropertyButton;
    private Button leftStateButton;
    private Button rightStateButton;

    public ShowBlockScreen(ShowBlockEntity blockEntity, BlockState newBlockState) {
        super(GameNarrator.NO_TITLE);
        this.blockEntity = blockEntity;
        this.newBlockState = newBlockState;
        if (blockEntity.getSlot() < blockEntity.getTransformData().size()) {
            this.slot = blockEntity.getSlot();
        }
    }

    private static int top(int i, int offset) {
        return 40 + 20 * i + offset;
    }

    public void setSlot(int slot) {
        for (TransformType key : this.storage.keySet()) {
            TransformDataOncePacket.sendToServerSide(this.blockEntity.getBlockPos(), this.slot, key, this.storage.get((Object)key));
        }
        this.storage.clear();
        this.slot = slot;
        this.blockEntity.setSlot(slot);
        for (TransformComponent component : this.panel.values()) {
            component.setSliderInitial(this.blockEntity, this.slot);
        }
        this.shownStateButton.setValue((Object)this.blockEntity.getTransformData((int)slot).isShown);
        this.updateStateButtonVisible(true);
    }

    private TransformComponent choose(TransformType type) {
        return this.panel.computeIfAbsent(type, TransformComponent::new);
    }

    public boolean updateStateButtonVisible(boolean force) {
        boolean stateButtonVisible;
        Collection<Property<?>> collection = this.blockStateList.updateRenderProperties(this.getBlockState());
        boolean bl = stateButtonVisible = !collection.isEmpty();
        if (stateButtonVisible && (this.property == null || force)) {
            this.property = collection.iterator().next();
        }
        this.leftStateButton.visible = stateButtonVisible;
        this.rightStateButton.visible = stateButtonVisible;
        this.leftPropertyButton.visible = stateButtonVisible;
        this.rightPropertyButton.visible = stateButtonVisible;
        return stateButtonVisible;
    }

    public BlockState getBlockState() {
        return this.blockEntity.getTransformData((int)this.slot).blockState;
    }

    private int leftColumnX() {
        return this.width / 4 * 3 + 10;
    }

    private int leftColumnWidth() {
        return this.width / 4 - 20;
    }

    protected void init() {
        if (this.minecraft == null) {
            return;
        }
        Button addStateButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
            int chosen = this.blockStateList.getChosenOne();
            if (chosen != -1) {
                this.blockStateList.addSlot();
                this.blockEntity.getTransformData().add(new TransformBlockData());
                this.updateTransformDataServerImmediate(this.blockEntity.getTransformData(chosen), this.slot);
                TransformDataOncePacket.sendToServerSideSuccess(this.blockEntity.getBlockPos());
                this.updateStateButtonVisible(true);
            } else if (this.newBlockState != null) {
                this.blockStateList.addSlot();
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.getId((BlockState)this.newBlockState)));
                this.updateTransformData(TransformType.SHOWN, 1.0);
                this.updateStateButtonVisible(true);
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.add"))).bounds(2, 10, 20, 20).build();
        Button removeStateButton = Button.builder((Component)Component.literal((String)"\u00d7"), btn -> {
            this.updateTransformData(TransformType.REMOVE, 0.0);
            this.updateStateButtonVisible(true);
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.remove"))).bounds(22, 10, 20, 20).build();
        Button replaceButton = Button.builder((Component)Component.literal((String)"\u21c4"), btn -> {
            int chosen = this.blockStateList.getChosenOne();
            if (chosen != -1 && chosen != this.slot) {
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.getId((BlockState)this.blockEntity.getTransformData((int)chosen).blockState)));
                this.updateStateButtonVisible(true);
            } else {
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.getId((BlockState)this.newBlockState)));
                this.updateStateButtonVisible(true);
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.display.replace"))).bounds(42, 10, 20, 20).build();
        this.shownStateButton = CycleButton.booleanBuilder((Component)Component.literal((String)"\ud83d\udd76"), (Component)Component.literal((String)"\ud83d\udc40")).displayOnlyValue().withInitialValue((Object)true).withTooltip(on -> Tooltip.create((Component)(on != false ? Component.translatable((String)"gui.showBlockScreen.display.on") : Component.translatable((String)"gui.showBlockScreen.display.off")))).create(62, 10, 20, 20, (Component)Component.empty(), (btn, bl) -> this.updateTransformData(TransformType.SHOWN, bl != false ? 1.0 : 0.0));
        Button copyButton = Button.builder((Component)Component.literal((String)"\ud83d\udce4").withStyle(ChatFormatting.BOLD), btn -> {
            String res = ShareUtils.transfer(this.blockEntity.getTransformData());
            this.setClipboard(res);
            this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.copy_pass"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.share_hint")));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.copy"))).bounds(102, 10, 20, 20).build();
        Button parseButton = Button.builder((Component)Component.literal((String)"\ud83d\udce5").withStyle(ChatFormatting.BOLD), btn -> {
            String string = this.getClipboard();
            try {
                ShareUtils.ShareBlockInformation shareBlockInformation = ShareUtils.from(string);
                if (shareBlockInformation.blocks().isEmpty()) {
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.error"), (Component)Component.literal((String)"No block data found")));
                    return;
                }
                this.checkModLack(shareBlockInformation);
                this.updateAllTransformData(shareBlockInformation);
                this.updateStateButtonVisible(true);
                this.minecraft.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.paste_pass"), null));
            }
            catch (Exception e) {
                this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.error"), (Component)Component.literal((String)e.getMessage())));
            }
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.paste"))).bounds(122, 10, 20, 20).build();
        Button saveButton = Button.builder((Component)Component.literal((String)"\ud83d\udcbe").withStyle(ChatFormatting.BOLD), btn -> this.minecraft.setScreen((Screen)new EditScreen(this, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save.tip"), string -> {
            if (string != null) {
                String res = ShareUtils.transfer(this.blockEntity.getTransformData());
                try {
                    EngraveBlockResultLoader.saveBlock(res, string);
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save_pass"), (Component)Component.translatable((String)"gui.showBlockScreen.workshop.share_hint")));
                }
                catch (IOException e) {
                    this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"gui.showBlockScreen.workshop.save_error"), (Component)Component.literal((String)e.getMessage())));
                }
                this.minecraft.setScreen((Screen)this);
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, string -> true))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.showBlockScreen.workshop.save"))).bounds(142, 10, 20, 20).build();
        this.blockStateList = new BlockStateIconList(this.minecraft, 40, 137, 2, 35, 40, 45, this.blockEntity.getTransformData(), this);
        this.leftPropertyButton = Button.builder((Component)Component.literal((String)"<"), btn -> {
            this.property = YuushyaBlockStates.getRelative(this.blockStateList.updateRenderProperties(this.getBlockState()), this.property, true);
        }).bounds(2, 177, 10, 20).build();
        this.rightPropertyButton = Button.builder((Component)Component.literal((String)">"), btn -> {
            this.property = YuushyaBlockStates.getRelative(this.blockStateList.updateRenderProperties(this.getBlockState()), this.property, false);
        }).bounds(62, 177, 10, 20).build();
        this.leftStateButton = Button.builder((Component)Component.literal((String)"<"), btn -> {
            BlockState nextBlockState = YuushyaBlockStates.cycleState(this.getBlockState(), this.property, true);
            this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.getId((BlockState)nextBlockState)));
        }).bounds(2, 197, 10, 20).build();
        this.rightStateButton = Button.builder((Component)Component.literal((String)">"), btn -> {
            BlockState nextBlockState = YuushyaBlockStates.cycleState(this.getBlockState(), this.property, true);
            this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.getId((BlockState)nextBlockState)));
        }).bounds(62, 197, 10, 20).build();
        CycleButton shapeButton = CycleButton.builder(BlockShape::getSymbol).displayOnlyValue().withValues((Object[])BlockShape.values()).withInitialValue((Object)TransformType.SHAPE.extractShape(this.blockEntity)).create(this.leftColumnX() - 50, 10, 40, 20, (Component)Component.literal((String)"shape"), (button, shape) -> this.updateTransformData(TransformType.SHAPE, Double.valueOf(shape.ordinal())));
        this.modeButton = CycleButton.builder(Mode::getSymbol).displayOnlyValue().withValues((Object[])Mode.values()).withInitialValue((Object)Mode.SLIDER).withTooltip(mode -> Tooltip.create((Component)(switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"gui.showBlockScreen.mode.slider.tooltip");
            case 1 -> Component.translatable((String)"gui.showBlockScreen.mode.fine_tune.tooltip");
            case 2 -> Component.translatable((String)"gui.showBlockScreen.mode.edit.tooltip");
        }))).create(this.leftColumnX(), 10, this.leftColumnWidth(), 20, (Component)Component.literal((String)"MODE"), (btn, mode) -> {
            switch (mode.ordinal()) {
                case 0: {
                    this.panel.values().forEach(TransformComponent::setSliderStep);
                    break;
                }
                case 1: 
                case 2: {
                    this.panel.values().forEach(TransformComponent::setSliderFineTune);
                }
            }
            switch (mode.ordinal()) {
                case 0: 
                case 1: {
                    this.panel.values().forEach(it -> it.triggerVisible(true));
                    break;
                }
                case 2: {
                    this.panel.values().forEach(it -> it.triggerVisible(false));
                }
            }
        });
        this.choose(TransformType.SCALE_X);
        double posX = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.x), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.x));
        this.choose((TransformType)TransformType.POS_X).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -posX, () -> posX, () -> PosTransItem.getStep(posX), number -> this.updateTransformData(TransformType.POS_X, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.DARK_RED))).step(this.choose(TransformType.POS_X).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowPosAxis();
        }).initial(TransformType.POS_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(0, 0), this.leftColumnWidth(), 20).build();
        double posY = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.y), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.y));
        this.choose((TransformType)TransformType.POS_Y).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -posY, () -> posY, () -> PosTransItem.getStep(posY), number -> this.updateTransformData(TransformType.POS_Y, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.GREEN))).step(this.choose(TransformType.POS_Y).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowPosAxis();
        }).initial(TransformType.POS_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(1, 0), this.leftColumnWidth(), 20).build();
        double posZ = Math.max(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.z), Math.abs(this.blockEntity.getTransformData((int)this.slot).pos.z));
        this.choose((TransformType)TransformType.POS_Z).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -posZ, () -> posZ, () -> PosTransItem.getStep(posZ), number -> this.updateTransformData(TransformType.POS_Z, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.BLUE))).step(this.choose(TransformType.POS_Z).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowPosAxis();
        }).initial(TransformType.POS_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(2, 0), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_X).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_X, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.DARK_RED))).step(this.choose(TransformType.ROT_X).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowRotAxis();
        }).initial(TransformType.ROT_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(3, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_Y).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_Y, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.GREEN))).step(this.choose(TransformType.ROT_Y).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowRotAxis();
        }).initial(TransformType.ROT_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(4, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_Z).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_Z, (Double)number)).text((caption, number) -> Component.empty().append(caption).append((Component)Component.translatable((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).withStyle(ChatFormatting.BLUE))).step(this.choose(TransformType.ROT_Z).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowRotAxis();
        }).initial(TransformType.ROT_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(5, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.SCALE_X).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.empty(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformData(TransformType.SCALE_X, (Double)number);
            this.updateTransformData(TransformType.SCALE_Y, (Double)number);
            this.updateTransformData(TransformType.SCALE_Z, (Double)number);
            this.choose((TransformType)TransformType.POS_X).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_X).sliderButton.getValidatedValue());
            this.choose((TransformType)TransformType.POS_Y).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_Y).sliderButton.getValidatedValue());
            this.choose((TransformType)TransformType.POS_Z).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_Z).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.translatable((String)"gui.yuushya.showBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.choose(TransformType.SCALE_X).setStandardStep(0.1)).initial(TransformType.SCALE_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(6, 20), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.LIT).sliderButton = DoubleRange.buttonBuilder((Component)Component.translatable((String)"gui.yuushya.showBlockScreen.brightness_text"), 0.0, 15.0, number -> this.updateTransformData(TransformType.LIT, (Double)number)).text(LazyDoubleRange::captionToString).step(this.choose(TransformType.LIT).setStandardStep(1.0)).initial(TransformType.LIT.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(7, 30), this.leftColumnWidth(), 20).build();
        for (TransformComponent component : this.panel.values()) {
            component.initWidget(this.font);
            this.addRenderableWidget((GuiEventListener)component.sliderButton);
            this.addRenderableWidget((GuiEventListener)component.minusButton);
            this.addRenderableWidget((GuiEventListener)component.addButton);
            this.addRenderableWidget((GuiEventListener)component.editBox);
            this.addRenderableWidget((GuiEventListener)component.cancelButton);
            this.addRenderableWidget((GuiEventListener)component.finishButton);
        }
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.addRenderableWidget((GuiEventListener)shapeButton);
        this.addWidget((GuiEventListener)this.blockStateList);
        this.addRenderableWidget((GuiEventListener)addStateButton);
        this.addRenderableWidget((GuiEventListener)removeStateButton);
        this.addRenderableWidget((GuiEventListener)replaceButton);
        this.addRenderableWidget((GuiEventListener)this.shownStateButton);
        this.addRenderableWidget((GuiEventListener)this.leftPropertyButton);
        this.addRenderableWidget((GuiEventListener)this.rightPropertyButton);
        this.addRenderableWidget((GuiEventListener)this.leftStateButton);
        this.addRenderableWidget((GuiEventListener)this.rightStateButton);
        this.addRenderableWidget((GuiEventListener)copyButton);
        this.addRenderableWidget((GuiEventListener)parseButton);
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.blockStateList.setSelectedSlot(this.slot);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.blockStateList.render(guiGraphics, mouseX, mouseY, partialTick);
        BlockState blockState = this.getBlockState();
        guiGraphics.drawString(this.font, (Component)this.blockStateList.updateRenderDisplayName(blockState), 45, 36, -1, false);
        List<String> properties = this.blockStateList.updateRenderBlockStateProperties(blockState);
        for (int i = 0; i < properties.size(); ++i) {
            MutableComponent displayBlockState = Component.literal((String)properties.get(i));
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, (Component)displayBlockState, 45, 36 + 9 * (i + 1) + 1, 16772038, false);
        }
        if (this.updateStateButtonVisible(false)) {
            guiGraphics.drawString(this.font, this.property.getName(), 22, 182, -1, false);
            guiGraphics.drawString(this.font, YuushyaDebugStickItem.getNameHelper(blockState, this.property), 22, 202, -1, false);
        }
        if (this.modeButton.getValue() == Mode.EDIT) {
            for (TransformComponent component : this.panel.values()) {
                guiGraphics.drawString(this.font, component.editBox.getMessage(), component.editBox.getX() + component.editBox.getWidth() / 2, component.editBox.getY() + component.editBox.getHeight() / 3, 0x707070);
                component.editBox.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void removed() {
        for (TransformType key : this.storage.keySet()) {
            TransformDataOncePacket.sendToServerSide(this.blockEntity.getBlockPos(), this.slot, key, this.storage.get((Object)key));
        }
        this.storage.clear();
        TransformDataOncePacket.sendToServerSideSuccess(this.blockEntity.getBlockPos());
    }

    public void checkModLack(ShareUtils.ShareBlockInformation shareBlockInformation) {
        List<String> unLoaded = shareBlockInformation.mods().stream().filter(id -> !Platform.getModIds().contains(id)).toList();
        Minecraft.getInstance().getToasts().addToast((Toast)SystemToast.multiline((Minecraft)Minecraft.getInstance(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.literal((String)"Mod Lack"), (Component)Component.literal((String)String.join((CharSequence)", ", unLoaded))));
    }

    private void updateAllTransformData(ShareUtils.ShareBlockInformation shareBlockInformation) {
        int slot;
        List<TransformBlockData> dataList = this.blockEntity.getTransformData();
        BlockPos pos = this.blockEntity.getBlockPos();
        int currentSize = dataList.size();
        for (int slot2 = 0; slot2 < currentSize; ++slot2) {
            this.blockEntity.removeTransformData(slot2);
            TransformDataOncePacket.sendToServerSide(pos, slot2, TransformType.REMOVE, 0.0);
        }
        shareBlockInformation.transfer(dataList);
        int nextSize = dataList.size();
        this.blockEntity.getLevel().sendBlockUpdated(pos, this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
        this.storage.clear();
        for (slot = 0; slot < nextSize; ++slot) {
            TransformBlockData data = dataList.get(slot);
            this.updateTransformDataServerImmediate(data, slot);
        }
        TransformDataOncePacket.sendToServerSideSuccess(pos);
        for (slot = nextSize - 1; slot < currentSize; ++slot) {
            this.blockEntity.setSlot(slot);
        }
        this.blockStateList.updateRenderList();
    }

    private void updateTransformDataServerImmediate(TransformBlockData data, int slot) {
        BlockPos pos = this.blockEntity.getBlockPos();
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.POS_X, data.pos.x);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.POS_Y, data.pos.y);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.POS_Z, data.pos.z);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.ROT_X, data.rot.x);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.ROT_Y, data.rot.y);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.ROT_Z, data.rot.z);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.SCALE_X, data.scales.x);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.SCALE_Y, data.scales.y);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.SCALE_Z, data.scales.z);
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.BLOCK_STATE, Block.getId((BlockState)data.blockState));
        TransformDataOncePacket.sendToServerSide(pos, slot, TransformType.SHOWN, data.isShown ? 1.0 : 0.0);
    }

    private void updateTransformData(TransformType type, Double number) {
        this.storage.put(type, number);
        type.modify(this.blockEntity, this.slot, number);
        this.blockEntity.getLevel().sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 11);
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    private void setClipboard(String clipboardValue) {
        if (this.minecraft != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.minecraft, (String)clipboardValue);
        }
    }

    public static enum Mode implements StringRepresentable
    {
        SLIDER("slider"),
        FINE_TUNE("fine_tune"),
        EDIT("edit");

        private final String name;
        private final Component symbol;

        private Mode(String name) {
            this.name = name;
            this.symbol = Component.translatable((String)("gui.showBlockScreen.mode." + name));
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @Generated
        public Component getSymbol() {
            return this.symbol;
        }
    }
}

