/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.validate;

import com.yuushya.modelling.gui.validate.DoubleRange;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.widget.SliderButton;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DividedDoubleRange
extends DoubleRange {
    private final Double middle;

    public DividedDoubleRange(Double minInclusive, Double middle, Double maxInclusive) {
        super(minInclusive, maxInclusive);
        this.middle = middle;
    }

    @Override
    public Double fromSliderValue(double sliderValue) {
        if (sliderValue <= 0.5) {
            return Mth.map((double)sliderValue, (double)0.0, (double)0.5, (double)this.minInclusive, (double)this.middle);
        }
        return Mth.map((double)sliderValue, (double)0.5, (double)1.0, (double)this.middle, (double)this.maxInclusive);
    }

    @Override
    public double toSliderValue(Double value) {
        if (value <= this.middle) {
            return Mth.map((double)value, (double)this.minInclusive, (double)this.middle, (double)0.0, (double)0.5);
        }
        return Mth.map((double)value, (double)this.middle, (double)this.maxInclusive, (double)0.5, (double)1.0);
    }

    public static ButtonBuilder buttonBuilder(Component caption, Double minInclusive, Double middle, Double maxInclusive, Consumer<Double> onValueChanged) {
        return new ButtonBuilder(caption, minInclusive, middle, maxInclusive, onValueChanged);
    }

    public static class ButtonBuilder
    extends SliderButton.Builder<Double> {
        public ButtonBuilder(Component caption, Double minInclusive, Double middle, Double maxInclusive, Consumer<Double> onValueChanged) {
            super(caption, new DividedDoubleRange(minInclusive, middle, maxInclusive), onValueChanged);
            this.text(LazyDoubleRange::captionToString);
            this.initial(minInclusive);
        }
    }
}

