/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.validate;

import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.validate.StepRange;
import com.yuushya.modelling.gui.validate.ValidateRange;
import com.yuushya.modelling.gui.widget.SliderButton;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DoubleRange
implements ValidateRange<Double>,
StepRange<Double> {
    protected final Double minInclusive;
    protected final Double maxInclusive;
    private double step = 0.001;

    public DoubleRange(Double minInclusive, Double maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    @Override
    public Optional<Double> validateValue(Double value) {
        if (value < this.minInclusive()) {
            return Optional.of(this.minInclusive());
        }
        if (value > this.maxInclusive()) {
            return Optional.of(this.maxInclusive());
        }
        return Optional.of(DoubleRange.near(value / this.step) * this.step);
    }

    @Override
    public double toSliderValue(Double value) {
        return Mth.map((double)value, (double)this.minInclusive, (double)this.maxInclusive, (double)0.0, (double)1.0);
    }

    @Override
    public Double fromSliderValue(double sliderValue) {
        return Mth.map((double)sliderValue, (double)0.0, (double)1.0, (double)this.minInclusive, (double)this.maxInclusive);
    }

    @Override
    public Double minInclusive() {
        return this.minInclusive;
    }

    @Override
    public Double maxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setStep(Double step) {
        this.step = step;
    }

    @Override
    public Double getStep() {
        return this.step;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DoubleRange that = (DoubleRange)obj;
        return Objects.equals(this.minInclusive, that.minInclusive) && Objects.equals(this.maxInclusive, that.maxInclusive) && Objects.equals(this.step, that.step);
    }

    public int hashCode() {
        return Objects.hash(this.minInclusive, this.maxInclusive, this.step);
    }

    public String toString() {
        return "DoubleRange[minInclusive=" + this.minInclusive + ", maxInclusive=" + this.maxInclusive + ", step=" + this.step + "]";
    }

    public static ButtonBuilder buttonBuilder(Component caption, Double minInclusive, Double maxInclusive, Consumer<Double> onValueChanged) {
        return new ButtonBuilder(caption, minInclusive, maxInclusive, onValueChanged);
    }

    public static Double near(Double value) {
        double ceil = Math.ceil(value);
        if (ceil - value < 0.001) {
            return ceil;
        }
        return Math.floor(value);
    }

    public static class ButtonBuilder
    extends SliderButton.Builder<Double> {
        public ButtonBuilder(Component caption, Double minInclusive, Double maxInclusive, Consumer<Double> onValueChanged) {
            super(caption, new DoubleRange(minInclusive, maxInclusive), onValueChanged);
            this.text(LazyDoubleRange::captionToString);
            this.initial(minInclusive);
        }
    }
}

