/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.gui.showblock.ShowBlockScreen;
import com.yuushya.modelling.registries.YuushyaRegistries;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockStateIconList
extends ObjectSelectionList<Entry> {
    protected final List<TransformBlockData> transformDataList;
    protected final List<Entry> chosen = new ArrayList<Entry>();
    protected final ShowBlockScreen screen;
    private final Map<Integer, MutableComponent> rememberDisplayName = new HashMap<Integer, MutableComponent>();
    private final Map<Integer, List<String>> rememberBlockStateProperties = new HashMap<Integer, List<String>>();
    private final Map<Integer, ItemStack> rememberItemStack = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Collection<Property<?>>> rememberProperties = new HashMap();
    private int itemHeight;
    private int itemWidth;

    public BlockStateIconList(Minecraft minecraft, int width, int height, int x, int y0, int itemWidth, int itemHeight, List<TransformBlockData> transformDataList, ShowBlockScreen showBlockScreen) {
        super(minecraft, width, height, y0, itemHeight);
        this.setX(x);
        this.transformDataList = transformDataList;
        this.screen = showBlockScreen;
        this.centerListVertically = false;
        this.setRenderHeader(false, 0);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.updateRenderList();
    }

    public MutableComponent updateRenderDisplayName(BlockState blockState) {
        return this.rememberDisplayName.computeIfAbsent(Block.getId((BlockState)blockState), id -> {
            BlockState blockState1 = Block.stateById((int)id);
            Item item = blockState1.getBlock().asItem();
            return item == Items.AIR ? blockState1.getBlock().getName() : (MutableComponent)item.getName(item.getDefaultInstance());
        });
    }

    public List<String> updateRenderBlockStateProperties(BlockState blockState) {
        return this.rememberBlockStateProperties.computeIfAbsent(Block.getId((BlockState)blockState), id -> Block.stateById((int)id).getValues().entrySet().stream().map(YuushyaUtils.PROPERTY_ENTRY_TO_STRING_FUNCTION).toList());
    }

    public ItemStack updateRenderItemstack(BlockState blockState) {
        return this.rememberItemStack.computeIfAbsent(Block.getId((BlockState)blockState), id -> {
            ItemStack itemStack = ((Item)YuushyaRegistries.ITEMS.get("get_blockstate_item").get()).getDefaultInstance();
            itemStack.set((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)Block.stateById((int)id));
            return itemStack;
        });
    }

    public Collection<Property<?>> updateRenderProperties(BlockState blockState) {
        return this.rememberProperties.computeIfAbsent(Block.getId((BlockState)blockState), id -> Block.stateById((int)id).getBlock().getStateDefinition().getProperties());
    }

    public int getRowWidth() {
        return this.itemWidth;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - 4;
    }

    public void updateRenderList() {
        this.clearEntries();
        for (int i = 0; i < this.transformDataList.size(); ++i) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(this, i));
        }
        this.notifyListUpdated();
    }

    public void addSlot() {
        if (this.getSelected() != null && this.transformDataList.get((int)((Entry)this.getSelected()).slot).blockState.getBlock() == Blocks.AIR) {
            return;
        }
        if (this.children().size() == this.transformDataList.size()) {
            Entry entry = new Entry(this, this.transformDataList.size());
            this.addEntry((AbstractSelectionList.Entry)entry);
            this.setSelected(entry);
        }
    }

    private void notifyListUpdated() {
    }

    public void setSelectedSlot(int slot) {
        this.setSelected((Entry)((Object)this.children().get(slot)));
    }

    public void setSelected(@Nullable Entry selected) {
        super.setSelected((AbstractSelectionList.Entry)selected);
        if (selected != null) {
            this.screen.setSlot(selected.slot);
        }
    }

    public int getChosenOne() {
        if (!this.chosen.isEmpty()) {
            return this.chosen.getLast().slot;
        }
        return -1;
    }

    public void setChosenCurrent() {
        Entry selected = (Entry)this.getSelected();
        if (selected != null) {
            selected.chosen = true;
            this.chosen.add(selected);
        }
    }

    public void clearChosen() {
        for (Entry entry : this.chosen) {
            entry.chosen = false;
        }
        this.chosen.clear();
    }

    public static final class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final BlockStateIconList parent;
        private final int slot;
        private final Minecraft minecraft;
        private boolean chosen = false;

        public Entry(BlockStateIconList parent, int slot) {
            this.parent = parent;
            this.minecraft = parent.minecraft;
            this.slot = slot;
        }

        public TransformBlockData getTransformData() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get(this.slot) : new TransformBlockData();
        }

        public BlockState updateRenderState() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).blockState : Blocks.AIR.defaultBlockState();
        }

        public boolean updateRenderShown() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).isShown : true;
        }

        public Component getNarration() {
            BlockState blockState = this.updateRenderState();
            Item item = blockState.getBlock().asItem();
            MutableComponent displayName = item == Items.AIR ? blockState.getBlock().getName() : (MutableComponent)item.getName(item.getDefaultInstance());
            return displayName;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Entry preSelected = (Entry)this.parent.getSelected();
            this.parent.setSelected(this);
            if (preSelected == this) {
                if (this.chosen) {
                    this.chosen = false;
                    this.parent.chosen.remove((Object)this);
                } else {
                    this.chosen = true;
                    this.parent.chosen.add(this);
                }
            }
            return true;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            BlockState blockState = this.updateRenderState();
            MutableComponent displayName = this.parent.updateRenderDisplayName(blockState);
            Font font = this.minecraft.font;
            Objects.requireNonNull(font);
            int fontHeight = 9;
            guiGraphics.drawString(font, (Component)displayName, left + 3, top + 32, 0xFFFFFF, false);
            if (this.updateRenderShown()) {
                guiGraphics.fill(left, top, left + 32 + 4, top + fontHeight + 32, -1601138544);
            }
            if (this.chosen) {
                guiGraphics.fill(left, top, left + 32 + 4, top + fontHeight + 32, 1608014895);
            }
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(left + 16), (float)(top + 16), 32.0f);
            guiGraphics.pose().scale(32.0f, -32.0f, 32.0f);
            ItemStack itemStack = this.parent.updateRenderItemstack(blockState);
            BakedModel model = this.minecraft.getItemRenderer().getModel(itemStack, (Level)this.minecraft.level, null, this.minecraft.player.getId());
            this.minecraft.getItemRenderer().render(itemStack, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            guiGraphics.pose().popPose();
        }
    }
}

