/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.mojang.blaze3d.platform.NativeImage;
import com.yuushya.modelling.utils.ShareUtils;
import java.awt.Color;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ColorTexture
implements AutoCloseable {
    private static ResourceLocation HueTextureLocation;
    private static ResourceLocation WhiteTextureLocation;
    private static ResourceLocation BlackTextureLocation;
    private final DynamicTexture HueTexture = new DynamicTexture(256, 1, false);
    private final DynamicTexture WhiteTexture = new DynamicTexture(256, 1, false);
    private final DynamicTexture BlackTexture = new DynamicTexture(1, 256, false);

    public ColorTexture() {
        int y;
        int abgr;
        int rgba;
        int b;
        int g;
        int r;
        int x;
        HueTextureLocation = Minecraft.getInstance().getTextureManager().register("dynamic", this.HueTexture);
        WhiteTextureLocation = Minecraft.getInstance().getTextureManager().register("dynamic", this.WhiteTexture);
        BlackTextureLocation = Minecraft.getInstance().getTextureManager().register("dynamic", this.BlackTexture);
        NativeImage lightPixels = this.HueTexture.getPixels();
        NativeImage whitePixels = this.WhiteTexture.getPixels();
        NativeImage blackPixels = this.BlackTexture.getPixels();
        for (x = 0; x < 256; ++x) {
            float hue = (float)x / 256.0f;
            int rgba2 = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            int abgr2 = ShareUtils.getABGR(rgba2);
            for (int y2 = 0; y2 < 1; ++y2) {
                lightPixels.setPixelRGBA(x, y2, abgr2);
            }
        }
        for (x = 0; x < 256; ++x) {
            int alpha = 255 - x * 255 / 255;
            r = 255;
            g = 255;
            b = 255;
            rgba = alpha << 24 | r << 16 | g << 8 | b;
            abgr = ShareUtils.getABGR(rgba);
            for (y = 0; y < 1; ++y) {
                whitePixels.setPixelRGBA(x, y, abgr);
            }
        }
        for (x = 0; x < 256; ++x) {
            int alpha = x * 255 / 255;
            r = 0;
            g = 0;
            b = 0;
            rgba = alpha << 24 | r << 16 | g << 8 | b;
            abgr = ShareUtils.getABGR(rgba);
            for (y = 0; y < 1; ++y) {
                blackPixels.setPixelRGBA(y, x, abgr);
            }
        }
        this.HueTexture.upload();
        this.WhiteTexture.upload();
        this.BlackTexture.upload();
    }

    @Override
    public void close() {
        this.HueTexture.close();
        this.WhiteTexture.close();
        this.BlackTexture.close();
    }

    @Generated
    public static ResourceLocation getHueTextureLocation() {
        return HueTextureLocation;
    }

    @Generated
    public static ResourceLocation getWhiteTextureLocation() {
        return WhiteTextureLocation;
    }

    @Generated
    public static ResourceLocation getBlackTextureLocation() {
        return BlackTextureLocation;
    }
}

