/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import com.yuushya.modelling.gui.itemblock.ItemBlockScreen;
import com.yuushya.modelling.gui.widget.ColorTexture;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;

public class ColorWidget
extends AbstractWidget {
    private final ItemBlockScreen itemBlockScreen;
    private final int WIDTH = 75;
    private final int xPadding = 5;
    private final int yPadding = 5;
    private final int yHeight = 65;
    float[] hsbVals = new float[3];

    public ColorWidget(int posX, int posY, int width, int height, int finalColor, Component message, ItemBlockScreen itemBlockScreen) {
        super(posX, posY, width, height, message);
        this.itemBlockScreen = itemBlockScreen;
        Color color = new Color(finalColor);
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.hsbVals);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        String hsv = String.format("H: %.2f S: %.2f V: %.2f", Float.valueOf(this.hsbVals[0]), Float.valueOf(this.hsbVals[1]), Float.valueOf(this.hsbVals[2]));
        guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 26, FastColor.ARGB32.color((int)72, (int)0, (int)0, (int)0));
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight() + 25, FastColor.ARGB32.color((int)72, (int)0, (int)0, (int)0));
        guiGraphics.drawString(this.itemBlockScreen.getFont(), hsv, this.getX() + 5, this.getY() + 145, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255), false);
        RenderSystem.enableBlend();
        guiGraphics.blit(ColorTexture.getHueTextureLocation(), this.getX() + 5, this.getY() + 35, 0, 0.0f, 0.0f, 75, 10, 90, 10);
        PoseStack pose = guiGraphics.pose();
        this.renderSolidColor(pose, this.getX() + 5 - 1, this.getX() + 5 + 75 + 1, this.getY() + 65 - 1, this.getY() + 65 + 75 + 1, FastColor.ARGB32.color((int)72, (int)255, (int)255, (int)255));
        this.renderSolidColor(pose, this.getX() + 5, this.getX() + 5 + 75, this.getY() + 65, this.getY() + 65 + 75, Color.HSBtoRGB(this.hsbVals[0], 1.0f, 1.0f));
        this.innerBlit(ColorTexture.getWhiteTextureLocation(), pose, this.getX() + 5, this.getX() + 5 + 75, this.getY() + 65, this.getY() + 65 + 75);
        this.innerBlit(ColorTexture.getBlackTextureLocation(), pose, this.getX() + 5, this.getX() + 5 + 75, this.getY() + 65, this.getY() + 65 + 75);
        guiGraphics.fill(this.getX() + 5 - 1, this.getY() + 5 - 1, this.getX() + 25 + 1, this.getY() + 25 + 1, FastColor.ARGB32.color((int)72, (int)255, (int)255, (int)255));
        guiGraphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 25, this.getY() + 25, Color.HSBtoRGB(this.hsbVals[0], this.hsbVals[1], this.hsbVals[2]));
        RenderSystem.disableBlend();
        int hueX = (int)((float)(this.getX() + 5) + this.hsbVals[0] * 75.0f);
        int hueY = this.getY() + 35;
        this.drawArrow(guiGraphics, hueX, hueY);
        int satX = (int)((float)(this.getX() + 5) + this.hsbVals[1] * 75.0f);
        int valY = (int)((float)(this.getY() + 65) + (1.0f - this.hsbVals[2]) * 75.0f);
        this.drawCross(guiGraphics, satX, valY);
    }

    private void drawCross(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.hLine(x - 2, x + 2, y, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x, y - 3, y + 3, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
    }

    private void drawArrow(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.vLine(x, y - 4, y + 4, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x - 1, y - 4, y + 3, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x + 1, y - 4, y + 3, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x - 2, y - 4, y + 2, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x + 2, y - 4, y + 2, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x - 3, y - 4, y + 1, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x + 3, y - 4, y + 1, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        guiGraphics.vLine(x, y - 3, y + 3, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        guiGraphics.vLine(x - 1, y - 3, y + 2, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        guiGraphics.vLine(x + 1, y - 3, y + 2, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        guiGraphics.vLine(x - 2, y - 3, y + 1, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        guiGraphics.vLine(x + 2, y - 3, y + 1, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.itemBlockScreen.setFocused((GuiEventListener)this);
        this.itemBlockScreen.setDragging(true);
        this.changeColor(mouseX, mouseY);
        this.itemBlockScreen.colorApplyButton.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.changeColor(mouseX, mouseY);
    }

    private void changeColor(double mouseX, double mouseY) {
        double clampedX;
        if (!this.visible) {
            return;
        }
        mouseX -= (double)this.getX();
        mouseY -= (double)this.getY();
        int MARGIN = 4;
        if (mouseY >= 35.0 && mouseY <= 45.0 && mouseX >= 1.0 && mouseX <= 84.0) {
            float hue;
            clampedX = Math.max(5.0, Math.min(mouseX, 80.0));
            this.hsbVals[0] = hue = (float)((clampedX - 5.0) / 75.0);
            this.updateData();
            this.setEditBox();
        }
        if (mouseY >= 61.0 && mouseY <= 144.0 && mouseX >= 1.0 && mouseX <= 84.0) {
            float saturation;
            clampedX = Math.max(5.0, Math.min(mouseX, 80.0));
            double clampedY = Math.max(65.0, Math.min(mouseY, 140.0));
            float brightness = 1.0f - (float)((clampedY - 65.0) / 75.0);
            this.hsbVals[1] = saturation = (float)((clampedX - 5.0) / 75.0);
            this.hsbVals[2] = brightness;
            this.updateData();
            this.setEditBox();
        }
    }

    private void setEditBox() {
        int rgb = Color.getHSBColor(this.hsbVals[0], this.hsbVals[1], this.hsbVals[2]).getRGB();
        String hex = String.format("#%06X", 0xFFFFFF & rgb);
        this.itemBlockScreen.colorEditBox.setValue(hex);
    }

    private void updateData() {
        this.itemBlockScreen.updateTransformDataClient(ItemTransformType.COLOR, Double.valueOf(Color.HSBtoRGB(this.hsbVals[0], this.hsbVals[1], this.hsbVals[2])));
    }

    public void setColor(int color) {
        Color c = new Color(color);
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.hsbVals);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    void innerBlit(ResourceLocation atlasLocation, PoseStack poseStack, int x1, int x2, int y1, int y2) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y2, 0.0f).setUv(0.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y1, 0.0f).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    void renderSolidColor(PoseStack poseStack, int x1, int x2, int y1, int y2, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y2, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(color);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y1, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

