/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import com.yuushya.modelling.gui.itemblock.ItemBlockScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class ItemStackIconList
extends ObjectSelectionList<Entry> {
    protected final List<TransformItemData> transformDataList;
    protected final List<Entry> chosen = new ArrayList<Entry>();
    protected final ItemBlockScreen screen;
    private int itemHeight;
    private int itemWidth;

    public ItemStackIconList(Minecraft minecraft, int width, int height, int x, int y0, int itemWidth, int itemHeight, List<TransformItemData> transformDataList, ItemBlockScreen itemBlockScreen) {
        super(minecraft, width, height, y0, itemHeight);
        this.setX(x);
        this.transformDataList = transformDataList;
        this.screen = itemBlockScreen;
        this.centerListVertically = false;
        this.setRenderHeader(false, 0);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.updateRenderList();
    }

    public void updateRenderList() {
        this.clearEntries();
        for (int i = 0; i < this.transformDataList.size(); ++i) {
            Entry entry = new Entry(this, i);
            this.addEntry((AbstractSelectionList.Entry)entry);
        }
    }

    public void addSlot() {
        if (this.getSelected() != null && this.transformDataList.get((int)((Entry)this.getSelected()).slot).itemStack.isEmpty()) {
            return;
        }
        if (this.children().size() == this.transformDataList.size()) {
            Entry entry = new Entry(this, this.transformDataList.size());
            this.addEntry((AbstractSelectionList.Entry)entry);
            this.setSelected(entry);
        }
    }

    public int getChosenOne() {
        if (!this.chosen.isEmpty()) {
            return this.chosen.getLast().slot;
        }
        return -1;
    }

    public void setSelected(@Nullable Entry selected) {
        super.setSelected((AbstractSelectionList.Entry)selected);
        if (selected != null) {
            this.screen.setSlot(selected.slot);
        }
    }

    public void setSelectedSlot(int slot) {
        this.setSelected((Entry)((Object)this.children().get(slot)));
    }

    public int getRowWidth() {
        return this.itemWidth;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.getWidth() - 4;
    }

    public class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final ItemStackIconList parent;
        private final int slot;
        private final Minecraft minecraft;
        private boolean chosen = false;
        private boolean animating = false;
        private long animStartMs = 0L;
        private static final long PHASE_MS = 80L;
        private static final long TOTAL_MS = 160L;
        private float cachedScaleX = 1.0f;
        private float cachedScaleY = 1.0f;
        private float cachedScaleZ = 1.0f;

        public Entry(ItemStackIconList parent, int slot) {
            this.parent = parent;
            this.minecraft = parent.minecraft;
            this.slot = slot;
        }

        public TransformItemData getTransformData() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get(this.slot) : new TransformItemData();
        }

        public ItemStack updateRenderState() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).itemStack : Items.AIR.getDefaultInstance();
        }

        public boolean updateRenderShown() {
            return this.parent.transformDataList.size() <= this.slot || this.parent.transformDataList.get((int)this.slot).isShown;
        }

        private void startPopupAnimation() {
            TransformItemData td = this.getTransformData();
            this.cachedScaleX = td.scales.x();
            this.cachedScaleY = td.scales.y();
            this.cachedScaleZ = td.scales.z();
            this.animStartMs = System.currentTimeMillis();
            this.animating = true;
        }

        private void applyAnimationIfNeeded() {
            float scaleFactor;
            if (!this.animating) {
                return;
            }
            long elapsed = System.currentTimeMillis() - this.animStartMs;
            if (elapsed >= 160L) {
                ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_X, Double.valueOf(this.cachedScaleX));
                ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_Y, Double.valueOf(this.cachedScaleY));
                ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_Z, Double.valueOf(this.cachedScaleZ));
                this.animating = false;
                return;
            }
            if (elapsed < 80L) {
                float p = (float)elapsed / 80.0f;
                scaleFactor = 1.0f + 0.1f * p;
            } else {
                float p = (float)(elapsed - 80L) / 80.0f;
                scaleFactor = 1.1f - 0.1f * p;
            }
            ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_X, Double.valueOf(this.cachedScaleX * scaleFactor));
            ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_Y, Double.valueOf(this.cachedScaleY * scaleFactor));
            ItemStackIconList.this.screen.updateTransformDataClient(ItemTransformType.SCALE_Z, Double.valueOf(this.cachedScaleZ * scaleFactor));
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.applyAnimationIfNeeded();
            ItemStack itemStack = this.updateRenderState();
            if (!itemStack.isEmpty()) {
                boolean flatItem;
                BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)x + (float)itemWidth / 2.0f, (float)y + (float)itemHeight / 2.0f, 100.0f);
                guiGraphics.pose().scale(24.0f, -24.0f, 24.0f);
                boolean bl = flatItem = !bakedModel.usesBlockLight();
                if (flatItem) {
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(180.0f));
                }
                Minecraft.getInstance().getItemRenderer().render(itemStack, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                guiGraphics.pose().popPose();
            }
            Font font = Minecraft.getInstance().font;
            String indexStr = String.valueOf(this.slot);
            int textX = x + itemWidth - font.width(indexStr) - 2;
            int textY = y + 2;
            guiGraphics.drawString(font, indexStr, textX, textY, 0xFFFFFF, true);
            if (isMouseOver || this == ItemStackIconList.this.getSelected()) {
                guiGraphics.fill(x - 1, y - 1, x + itemWidth + 1, y + itemHeight + 1, -2130706433);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Entry previousSelected = (Entry)this.parent.getSelected();
            if (previousSelected != this) {
                this.startPopupAnimation();
            }
            this.parent.setSelected(this);
            if (previousSelected == this) {
                if (this.chosen) {
                    this.chosen = false;
                    this.parent.chosen.remove((Object)this);
                } else {
                    this.chosen = true;
                    this.parent.chosen.add(this);
                }
            }
            return true;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.slot});
        }
    }
}

