/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.validate.ValidateRange;
import com.yuushya.modelling.gui.widget.SliderButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public final class ItemTransformComponent {
    public ItemTransformType type;
    public double standardStep;
    public double fine_tuneStep = 0.001;
    public SliderButton<Double> sliderButton;
    public Button minusButton;
    public Button addButton;
    public EditBox editBox;
    public Button cancelButton;
    public Button finishButton;

    public ItemTransformComponent(ItemTransformType type) {
        this.type = type;
    }

    public double setStandardStep(double step) {
        this.standardStep = step;
        return step;
    }

    public void setSliderInitial(ItemBlockEntity blockEntity, int slot) {
        double step = this.sliderButton.getStep();
        this.sliderButton.setStep(this.fine_tuneStep);
        this.sliderButton.setInitialValidatedValue(this.type.extract(blockEntity, slot));
        this.sliderButton.setStep(step);
        if (this.editBox != null) {
            this.editBox.setValue(String.valueOf(this.sliderButton.getValidatedValue()));
        }
    }

    public void setSliderStep() {
        this.sliderButton.setStep(this.standardStep);
    }

    public void setSliderFineTune() {
        this.sliderButton.setStep(this.fine_tuneStep);
    }

    public void initWidget(Font font) {
        this.minusButton = Button.builder((Component)Component.literal((String)"-"), btn -> {
            double currentValue = this.sliderButton.getValidatedValue();
            double newValue = currentValue - this.sliderButton.getStep();
            this.sliderButton.setValidatedValue(newValue);
        }).bounds(this.sliderButton.getX() - 10, this.sliderButton.getY(), 10, 20).build();
        this.addButton = Button.builder((Component)Component.literal((String)"+"), btn -> {
            double currentValue = this.sliderButton.getValidatedValue();
            double newValue = currentValue + this.sliderButton.getStep();
            this.sliderButton.setValidatedValue(newValue);
        }).bounds(this.sliderButton.getX() + this.sliderButton.getWidth(), this.sliderButton.getY(), 10, 20).build();
        this.editBox = new EditBox(font, this.sliderButton.getX(), this.sliderButton.getY(), this.sliderButton.getWidth(), 20, (Component)Component.empty());
        this.editBox.setMaxLength(15);
        this.editBox.visible = false;
        this.cancelButton = Button.builder((Component)Component.literal((String)"\u00d7").withStyle(ChatFormatting.RED), btn -> {
            this.editBox.setValue(String.valueOf(this.sliderButton.getValidatedValue()));
            this.triggerVisible(true);
        }).bounds(this.sliderButton.getX() - 10, this.sliderButton.getY(), 10, 20).build();
        this.cancelButton.visible = false;
        this.finishButton = Button.builder((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN), btn -> {
            this.saveEditBoxValue();
            this.triggerVisible(true);
        }).bounds(this.sliderButton.getX() + this.sliderButton.getWidth(), this.sliderButton.getY(), 10, 20).build();
        this.finishButton.visible = false;
    }

    public void saveEditBoxValue() {
        double number;
        try {
            number = Double.parseDouble(this.editBox.getValue());
        }
        catch (NumberFormatException ignored) {
            number = this.sliderButton.getValidatedValue();
        }
        ValidateRange<Double> validateRange = this.sliderButton.getValidateRange();
        if (validateRange instanceof LazyDoubleRange) {
            double finalNumber;
            LazyDoubleRange doubleValidateRange = (LazyDoubleRange)validateRange;
            double min = doubleValidateRange.minInclusive();
            double max = doubleValidateRange.maxInclusive();
            if (number < min) {
                finalNumber = number;
                doubleValidateRange.setMinInclusiveSupplier(() -> finalNumber);
            }
            if (number > max) {
                finalNumber = number;
                doubleValidateRange.setMaxInclusiveSupplier(() -> finalNumber);
            }
        }
        this.sliderButton.setValidatedValue(number);
        this.setEditBoxInitial();
    }

    public void setEditBoxInitial() {
        this.editBox.setValue(String.valueOf(this.sliderButton.getValidatedValue()));
    }

    public void triggerVisible(boolean sliderVisible) {
        this.sliderButton.visible = sliderVisible;
        this.minusButton.visible = sliderVisible;
        this.addButton.visible = sliderVisible;
        this.editBox.setVisible(!sliderVisible);
        this.cancelButton.visible = !sliderVisible;
        boolean bl = this.finishButton.visible = !sliderVisible;
        if (!sliderVisible) {
            this.editBox.setValue(String.valueOf(this.sliderButton.getValidatedValue()));
        }
    }

    public void setInvisible() {
        this.sliderButton.visible = false;
        this.minusButton.visible = false;
        this.addButton.visible = false;
        this.editBox.setVisible(false);
        this.cancelButton.visible = false;
        this.finishButton.visible = false;
    }
}

