/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.widget;

import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformType;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.gui.validate.ValidateRange;
import com.yuushya.modelling.gui.widget.SliderButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class TransformComponent {
    public TransformType type;
    public double standardStep;
    public double fine_tuneStep = 0.001;
    public SliderButton<Double> sliderButton;
    public Button minusButton;
    public Button addButton;
    public EditBox editBox;
    public Button cancelButton;
    public Button finishButton;

    public TransformComponent(TransformType type) {
        this.type = type;
    }

    public double setStandardStep(double step) {
        this.standardStep = step;
        return step;
    }

    public void setSliderInitial(ShowBlockEntity blockEntity, int slot) {
        double step = this.sliderButton.getStep();
        this.sliderButton.setStep(this.fine_tuneStep);
        this.sliderButton.setInitialValidatedValue(this.type.extract(blockEntity, slot));
        this.sliderButton.setStep(step);
    }

    public void setSliderStep() {
        this.sliderButton.setStep(this.standardStep);
    }

    public void setSliderFineTune() {
        this.sliderButton.setStep(this.fine_tuneStep);
    }

    public void step(boolean increase) {
        if (increase) {
            this.sliderButton.setValidatedValue(this.sliderButton.getValidatedValue() + this.sliderButton.getStep());
        } else {
            this.sliderButton.setValidatedValue(this.sliderButton.getValidatedValue() - this.sliderButton.getStep());
        }
    }

    public void setEditBoxInitial() {
        this.editBox.setValue(String.valueOf(this.sliderButton.getValidatedValue()));
    }

    public void saveEditBoxValue() {
        double number;
        try {
            number = Double.parseDouble(this.editBox.getValue());
        }
        catch (NumberFormatException ignored) {
            number = this.sliderButton.getValidatedValue();
        }
        ValidateRange<Double> validateRange = this.sliderButton.getValidateRange();
        if (validateRange instanceof LazyDoubleRange) {
            double finalNumber;
            LazyDoubleRange doubleValidateRange = (LazyDoubleRange)validateRange;
            double min = doubleValidateRange.minInclusive();
            double max = doubleValidateRange.maxInclusive();
            if (number < min) {
                finalNumber = number;
                doubleValidateRange.setMinInclusiveSupplier(() -> finalNumber);
            }
            if (number > max) {
                finalNumber = number;
                doubleValidateRange.setMaxInclusiveSupplier(() -> finalNumber);
            }
        }
        this.sliderButton.setValidatedValue(number);
        this.setEditBoxInitial();
    }

    public void triggerVisible(boolean sliderVisible) {
        this.sliderButton.visible = sliderVisible;
        this.addButton.visible = sliderVisible;
        this.minusButton.visible = sliderVisible;
        if (!sliderVisible) {
            this.setEditBoxInitial();
        }
        this.editBox.setVisible(!sliderVisible);
        this.finishButton.visible = !sliderVisible;
        this.cancelButton.visible = !sliderVisible;
    }

    Component editBoxComponent() {
        MutableComponent component = switch (this.type) {
            case TransformType.POS_X, TransformType.ROT_X -> Component.translatable((String)"block.yuushya.showblock.x", (Object[])new Object[]{""}).withStyle(ChatFormatting.DARK_RED);
            case TransformType.POS_Y, TransformType.ROT_Y -> Component.translatable((String)"block.yuushya.showblock.y", (Object[])new Object[]{""}).withStyle(ChatFormatting.GREEN);
            case TransformType.POS_Z, TransformType.ROT_Z -> Component.translatable((String)"block.yuushya.showblock.z", (Object[])new Object[]{""}).withStyle(ChatFormatting.BLUE);
            case TransformType.SCALE_X -> Component.translatable((String)"gui.yuushya.showBlockScreen.scale_text", (Object[])new Object[]{""});
            default -> Component.empty();
        };
        return Component.empty().append(this.sliderButton.getCaption()).append((Component)component);
    }

    public void initWidget(Font font) {
        this.minusButton = Button.builder((Component)Component.literal((String)"-"), btn -> this.step(false)).bounds(this.sliderButton.getX() - 10, this.sliderButton.getY(), 10, 20).build();
        this.addButton = Button.builder((Component)Component.literal((String)"+"), btn -> this.step(true)).bounds(this.sliderButton.getX() + this.sliderButton.getWidth(), this.sliderButton.getY(), 10, 20).build();
        this.editBox = new EditBox(font, this.sliderButton.getX(), this.sliderButton.getY(), this.sliderButton.getWidth(), 20, this.editBoxComponent());
        this.editBox.setMaxLength(15);
        this.setEditBoxInitial();
        this.cancelButton = Button.builder((Component)Component.literal((String)"\u00d7"), btn -> this.setEditBoxInitial()).bounds(this.sliderButton.getX() - 10, this.sliderButton.getY(), 10, 20).build();
        this.finishButton = Button.builder((Component)Component.literal((String)"\u221a"), btn -> this.saveEditBoxValue()).bounds(this.sliderButton.getX() + this.sliderButton.getWidth(), this.sliderButton.getY(), 10, 20).build();
        this.triggerVisible(true);
    }
}

