/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item;

import com.yuushya.modelling.item.AbstractYuushyaItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AbstractToolItem
extends AbstractYuushyaItem {
    public AbstractToolItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 119.5f;
    }

    public boolean canAttackBlock(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player) {
        InteractionResult result = this.inMainHandLeftClickOnBlock(player, blockState, level, blockPos, player.getItemInHand(InteractionHand.MAIN_HAND));
        if (!level.isClientSide && result.consumesAction()) {
            level.playSound(null, blockPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 0.2f);
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        BlockPos blockPos = player.blockPosition();
        ItemStack handItemStack = player.getItemInHand(hand);
        InteractionResultHolder resultHolder = hand == InteractionHand.OFF_HAND ? new InteractionResultHolder(this.inOffHandRightClickInAir(player, level.getBlockState(blockPos), level, blockPos, handItemStack), (Object)handItemStack) : new InteractionResultHolder(this.inMainHandRightClickInAir(player, level.getBlockState(blockPos), level, blockPos, handItemStack), (Object)handItemStack);
        if (!level.isClientSide && resultHolder.getResult().consumesAction()) {
            level.playSound(null, blockPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 0.2f);
        }
        return resultHolder;
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        Level level = useOnContext.getLevel();
        InteractionHand hand = useOnContext.getHand();
        BlockPos blockPos = useOnContext.getClickedPos();
        InteractionResult result = hand == InteractionHand.OFF_HAND ? this.inOffHandRightClickOnBlock(player, level.getBlockState(blockPos), level, blockPos, useOnContext.getItemInHand()) : this.inMainHandRightClickOnBlock(player, level.getBlockState(blockPos), level, blockPos, useOnContext.getItemInHand());
        if (!level.isClientSide && result.consumesAction()) {
            level.playSound(null, blockPos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 1.0f, 0.2f);
        }
        return result;
    }

    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return InteractionResult.PASS;
    }

    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return InteractionResult.PASS;
    }

    public InteractionResult inOffHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return InteractionResult.PASS;
    }

    public InteractionResult inMainHandRightClickInAir(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return InteractionResult.PASS;
    }

    public InteractionResult inOffHandRightClickInAir(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return InteractionResult.PASS;
    }
}

