/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.mojang.blaze3d.platform.Window;
import com.yuushya.modelling.gui.itemblock.ItemBlockScreen;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.registries.YuushyaRegistries;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ColorPickerItem
extends AbstractToolItem {
    public ColorPickerItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    private static void pickColor(Level level, ItemStack handItemStack) {
        if (level instanceof ClientLevel) {
            Window window = Minecraft.getInstance().getWindow();
            int width = window.getScreenWidth();
            int height = window.getScreenHeight();
            int centerX = width / 2;
            int centerY = height / 2;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)4);
            GL11.glReadPixels((int)centerX, (int)centerY, (int)1, (int)1, (int)6408, (int)5121, (ByteBuffer)buffer);
            int r = 255 - buffer.get(0) & 0xFF;
            int g = 255 - buffer.get(1) & 0xFF;
            int b = 255 - buffer.get(2) & 0xFF;
            int color = r << 16 | g << 8 | b;
            handItemStack.set((DataComponentType)YuushyaRegistries.COLOR_DATA.get(), (Object)color);
            ItemBlockScreen.setClipboard(String.format("#%06X", color));
        }
    }

    @Override
    public InteractionResult inMainHandRightClickInAir(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        ColorPickerItem.pickColor(level, handItemStack);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        ColorPickerItem.pickColor(level, handItemStack);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        Integer i = (Integer)handItemStack.get((DataComponentType)YuushyaRegistries.COLOR_DATA.get());
        if (i != null) {
            ItemBlockScreen.setClipboard(String.format("#%06X", i));
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
        Integer i = (Integer)itemStack.get((DataComponentType)YuushyaRegistries.COLOR_DATA.get());
        if (i != null) {
            String hex = String.format("#%08X", i);
            tooltips.add((Component)Component.literal((String)hex).withColor(i.intValue()));
        } else {
            tooltips.add((Component)Component.translatable((String)"item.yuushya.color_picker.none").withColor(Color.LIGHT_GRAY.getRGB()));
        }
        super.appendHoverText(itemStack, context, tooltips, tooltipFlag);
    }
}

