/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.AbstractTransformBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ITransformDataInventory;
import com.yuushya.modelling.blockentity.transformData.ITransformDataProvider;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.item.AbstractMultiPurposeToolItem;
import com.yuushya.modelling.registries.YuushyaRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DestroyItem
extends AbstractMultiPurposeToolItem {
    public DestroyItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    public static void saveToItem(ItemStack itemStack, BlockState blockState, HolderLookup.Provider registries) {
        ArrayList<TransformBlockData> transformDataList = new ArrayList<TransformBlockData>();
        TransformBlockData data = new TransformBlockData();
        data.blockState = blockState;
        data.isShown = true;
        transformDataList.add(data);
        DestroyItem.saveToItem(itemStack, transformDataList, registries);
    }

    public static void saveToItem(ItemStack itemStack, List<? extends ITransformDataProvider> transformDataList, HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        ITransformDataInventory.saveAdditional(compoundTag, transformDataList, registries);
        BlockItem.setBlockEntityData((ItemStack)itemStack, (BlockEntityType)((BlockEntityType)YuushyaRegistries.SHOW_BLOCK_ENTITY.get()), (CompoundTag)compoundTag);
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        ItemStack offhandItem = player.getOffhandItem();
        Item item = offhandItem.getItem();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.getBlock() instanceof AbstractTransformBlock)) {
            return InteractionResult.PASS;
        }
        if (blockState.getBlock() instanceof AbstractTransformBlock) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof AbstractTransformBlockEntity) {
                AbstractTransformBlockEntity showBlockEntity = (AbstractTransformBlockEntity)blockEntity;
                showBlockEntity.saveToItem(offhandItem, (HolderLookup.Provider)level.registryAccess());
                showBlockEntity.writeBlockState(offhandItem, blockState);
            }
        } else {
            DestroyItem.saveToItem(offhandItem, blockState, (HolderLookup.Provider)level.registryAccess());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        Block block = blockState.getBlock();
        if (block instanceof AbstractTransformBlock) {
            AbstractTransformBlock showBlock = (AbstractTransformBlock)block;
            block = level.getBlockEntity(blockPos);
            if (block instanceof AbstractTransformBlockEntity) {
                AbstractTransformBlockEntity showBlockEntity = (AbstractTransformBlockEntity)block;
                if (!level.isClientSide) {
                    ItemStack itemStack = new ItemStack((ItemLike)showBlock);
                    showBlockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess());
                    showBlockEntity.writeBlockState(itemStack, blockState);
                    level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
                    level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
                    if (!player.isCreative()) {
                        handItemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                    ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), itemStack);
                    itemEntity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

