/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.registries.YuushyaRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GetBlockStateItem
extends AbstractToolItem {
    private BlockState blockState = Blocks.AIR.defaultBlockState();

    public GetBlockStateItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        if (blockStateTarget.getBlock() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.getBlockEntity(blockPos);
            BlockState blockStateShowBlock = showBlockEntity.getTransFormDataNow().blockState;
            if (!(blockStateShowBlock.getBlock() instanceof AirBlock)) {
                blockStateTarget = blockStateShowBlock;
                showBlockEntity.removeTransFormDataNow();
                showBlockEntity.saveChanged();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".mainhand.pass")), true);
                return InteractionResult.PASS;
            }
        }
        this.blockState = blockStateTarget;
        this.setTag(handItemStack);
        player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".mainhand.success")), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inOffHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        if (this.blockState.getBlock() instanceof AirBlock) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".offhand.fail")), true);
            return InteractionResult.SUCCESS;
        }
        if (blockStateTarget.getBlock() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.getBlockEntity(blockPos);
            showBlockEntity.setSlotBlockStateNow(this.blockState);
            showBlockEntity.setSlotShown(showBlockEntity.getSlot(), true);
            showBlockEntity.saveChanged();
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".offhand.success")), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void getTag(ItemStack itemStack) {
        this.blockState = (BlockState)itemStack.getOrDefault((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)Blocks.AIR.defaultBlockState());
    }

    public void setTag(ItemStack itemStack) {
        itemStack.set((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)this.blockState);
    }

    public static void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BlockState blockState = (BlockState)stack.getOrDefault((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)Blocks.AIR.defaultBlockState());
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        itemRenderer.render(stack, displayContext, false, matrices, vertexConsumers, light, overlay, blockRenderDispatcher.getBlockModel(blockState));
    }
}

