/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.gui.itemblock.ItemBlockScreen;
import com.yuushya.modelling.gui.showblock.ShowBlockScreen;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.item.showblocktool.GetBlockStateItem;
import com.yuushya.modelling.registries.YuushyaRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GuiItem
extends AbstractToolItem {
    public GuiItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        if (level.isClientSide) {
            this.openGuiScreen(player, blockState, level, blockPos, handItemStack);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGuiScreen(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        ItemStack newItemStack = player.getItemInHand(InteractionHand.OFF_HAND);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        BlockState newBlockState = null;
        if (newItemStack.getItem() instanceof GetBlockStateItem) {
            newBlockState = (BlockState)newItemStack.getOrDefault((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)Blocks.AIR.defaultBlockState());
        } else {
            Item item = newItemStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                newBlockState = item2.getBlock().defaultBlockState();
            }
        }
        if (!newItemStack.isEmpty()) {
            newItemStack = newItemStack.copy();
        }
        if (blockEntity instanceof ShowBlockEntity) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
            Minecraft.getInstance().setScreen((Screen)new ShowBlockScreen(showBlockEntity, newBlockState));
        } else if (blockEntity instanceof ItemBlockEntity) {
            ItemBlockEntity itemBlockEntity = (ItemBlockEntity)blockEntity;
            Minecraft.getInstance().setScreen((Screen)new ItemBlockScreen(itemBlockEntity, newItemStack));
        }
    }
}

