/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.item.showblocktool.PosTransItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;

public class MicroPosTransItem
extends PosTransItem {
    public MicroPosTransItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
        this.MAX_FORMS = 4;
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return MicroPosTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3d pos = transformData.pos;
            switch (this.getForm()) {
                case 0: {
                    pos.x -= 0.001;
                    break;
                }
                case 1: {
                    pos.y -= 0.001;
                    break;
                }
                case 2: {
                    pos.z -= 0.001;
                    break;
                }
                case 3: {
                    pos.set((double)(Math.round(pos.x) % 17L), (double)(Math.round(pos.y) % 17L), (double)(Math.round(pos.z) % 17L));
                }
            }
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".switch"), (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        });
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return MicroPosTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3d pos = transformData.pos;
            switch (this.getForm()) {
                case 0: {
                    pos.x += 0.001;
                    break;
                }
                case 1: {
                    pos.y += 0.001;
                    break;
                }
                case 2: {
                    pos.z += 0.001;
                }
            }
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".switch"), (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        });
    }
}

