/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.registries.YuushyaRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.state.BlockState;

public class MoveTransformDataItem
extends AbstractToolItem {
    private final TransformBlockData transformData = new TransformBlockData();

    public MoveTransformDataItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(level, handItemStack);
        if (blockStateTarget.getBlock() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.getBlockEntity(blockPos);
            BlockState blockStateShowBlock = showBlockEntity.getTransFormDataNow().blockState;
            if (blockStateShowBlock.getBlock() instanceof AirBlock) {
                player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".mainhand.pass")), true);
                return InteractionResult.PASS;
            }
            this.transformData.set(showBlockEntity.getTransFormDataNow());
            showBlockEntity.removeTransFormDataNow();
            showBlockEntity.saveChanged();
        } else {
            this.transformData.set();
            this.transformData.blockState = blockStateTarget;
        }
        this.setTag(handItemStack, (HolderLookup.Provider)level.registryAccess());
        player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".mainhand.success")), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inOffHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(level, handItemStack);
        if (this.transformData.blockState.getBlock() instanceof AirBlock) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".offhand.fail")), true);
            return InteractionResult.SUCCESS;
        }
        if (blockStateTarget.getBlock() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.getBlockEntity(blockPos);
            showBlockEntity.getTransFormDataNow().set(this.transformData);
            showBlockEntity.saveChanged();
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".offhand.success")), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void getTag(Level level, ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault((DataComponentType)YuushyaRegistries.TRANSFORM_DATA.get(), (Object)CustomData.EMPTY);
        CompoundTag compoundTag = customData.copyTag();
        if (compoundTag.contains("TransformData")) {
            this.transformData.load(compoundTag.getCompound("TransformData"));
        } else {
            customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            compoundTag = customData.copyTag();
            if (compoundTag.contains("TransformData")) {
                this.transformData.load(compoundTag.getCompound("TransformData"));
            }
        }
    }

    public void setTag(ItemStack itemStack, HolderLookup.Provider registries) {
        CompoundTag transformDataTag = new CompoundTag();
        this.transformData.saveAdditional(transformDataTag, registries);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("TransformData", (Tag)transformDataTag);
        itemStack.set((DataComponentType)YuushyaRegistries.TRANSFORM_DATA.get(), (Object)CustomData.of((CompoundTag)compoundTag));
    }
}

