/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge;

import com.yuushya.modelling.YuushyaClient;
import com.yuushya.modelling.gui.engrave.EngraveScreen;
import com.yuushya.modelling.gui.widget.ColorTexture;
import com.yuushya.modelling.neoforge.client.NeoItemBlockModel;
import com.yuushya.modelling.neoforge.client.NeoShowBlockModel;
import com.yuushya.modelling.registries.YuushyaRegistries;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="yuushya_modelling", dist={Dist.CLIENT})
public class YuushyaClientNeoForge {
    public YuushyaClientNeoForge(IEventBus modBus) {
        if (FMLEnvironment.dist.isClient()) {
            modBus.addListener(this::onInitializeClient);
            modBus.addListener(this::onModelBaked);
            modBus.addListener(this::handleBlockColor);
            modBus.addListener(this::handleItemColor);
            modBus.addListener(this::onRegisterMenuScreensEvent);
        }
    }

    public void onRegisterMenuScreensEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)YuushyaRegistries.ENGRAVE_MENU.get(), EngraveScreen::new);
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            YuushyaClient.onInitializeClient();
            ColorTexture colorTexture = new ColorTexture();
        });
    }

    public void onModelBaked(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation inventory = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"showblock"), "inventory");
        event.getModels().put(inventory, new NeoShowBlockModel(Direction.SOUTH, (BakedModel)event.getModels().get(inventory)));
        for (BlockState blockState : ((Block)YuushyaRegistries.BLOCKS.get("showblock").get()).getStateDefinition().getPossibleStates()) {
            ModelResourceLocation stateResourceLocation = BlockModelShaper.stateToModelLocation((BlockState)blockState);
            event.getModels().put(stateResourceLocation, new NeoShowBlockModel((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), (BakedModel)event.getModels().get(stateResourceLocation)));
        }
        ModelResourceLocation inventory2 = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"yuushya", (String)"itemblock"), "inventory");
        event.getModels().put(inventory2, new NeoItemBlockModel(Direction.SOUTH, (BakedModel)event.getModels().get(inventory2)));
        for (BlockState blockState : ((Block)YuushyaRegistries.BLOCKS.get("itemblock").get()).getStateDefinition().getPossibleStates()) {
            ModelResourceLocation stateResourceLocation = BlockModelShaper.stateToModelLocation((BlockState)blockState);
            event.getModels().put(stateResourceLocation, new NeoItemBlockModel((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), (BakedModel)event.getModels().get(stateResourceLocation)));
        }
    }

    public void handleBlockColor(RegisterColorHandlersEvent.Block event) {
        event.register((state, view, pos, tintIndex) -> {
            if (tintIndex > -1) {
                BlockState trueState = Block.stateById((int)(tintIndex >> 8));
                int trueTint = tintIndex & 0xFF;
                return event.getBlockColors().getColor(trueState, view, pos, trueTint);
            }
            return -1;
        }, new Block[]{(Block)YuushyaRegistries.SHOW_BLOCK.get()});
    }

    public void handleItemColor(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, i) -> {
            BlockState blockState = (BlockState)itemStack.getOrDefault((DataComponentType)YuushyaRegistries.BLOCKSTATE.get(), (Object)Blocks.AIR.defaultBlockState());
            return event.getBlockColors().getColor(blockState, null, null, i);
        }, new ItemLike[]{(ItemLike)YuushyaRegistries.ITEMS.get("get_blockstate_item").get()});
        event.register((arg, tintIndex) -> {
            if (tintIndex > -1) {
                BlockState trueState = Block.stateById((int)(tintIndex >> 8));
                int trueTint = tintIndex & 0xFF;
                return event.getBlockColors().getColor(trueState, null, null, trueTint);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)YuushyaRegistries.ITEMS.get("showblock").get()});
    }
}

