/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client;

import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.blockentity.showblock.ShowBlockModel;
import com.yuushya.modelling.blockentity.transformData.ITransformDataInventory;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.IBakedModelExtension;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoShowBlockModel
extends ShowBlockModel
implements IBakedModelExtension,
BakedModel {
    private static final Map<ItemStack, NeoShowBlockModel> itemModelCache = new HashMap<ItemStack, NeoShowBlockModel>();
    public static ModelProperty<ShowBlockEntity> BASE_BLOCK_ENTITY = new ModelProperty();

    public NeoShowBlockModel(Direction facing) {
        super(facing);
    }

    public NeoShowBlockModel(Direction facing, BakedModel backup) {
        super(facing, backup);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        if (level.getBlockEntity(pos) == null) {
            return ModelData.builder().build();
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ShowBlockEntity) {
            ShowBlockEntity blockEntity1 = (ShowBlockEntity)blockEntity;
            return ModelData.builder().with(BASE_BLOCK_ENTITY, (Object)blockEntity1).build();
        }
        return ModelData.builder().build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ShowBlockEntity blockEntity = (ShowBlockEntity)data.get(BASE_BLOCK_ENTITY);
        if (blockEntity == null) {
            return Collections.emptyList();
        }
        return super.getQuads(state, side, rand, blockEntity.getTransformData());
    }

    @NotNull
    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        final CustomData data = (CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data == CustomData.EMPTY) {
            return List.of(this.backup);
        }
        return List.of((BakedModel)itemModelCache.computeIfAbsent(itemStack, _stack -> new NeoShowBlockModel(this, Direction.SOUTH){
            private final List<TransformBlockData> transformDatas;
            {
                super(facing);
                this.transformDatas = new ArrayList<TransformBlockData>();
                ITransformDataInventory.load(data.copyTag(), this.transformDatas);
            }

            @Override
            @NotNull
            public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, RandomSource rand) {
                return super.getQuads(blockState, side, rand, this.transformDatas);
            }
        }));
    }
}

