/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client.anvilcraft.rendering;

import com.yuushya.modelling.neoforge.client.anvilcraft.rendering.CachedRegion;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CacheableBERenderingPipeline {
    @Nullable
    private static CacheableBERenderingPipeline instance;
    private final ClientLevel level;
    private final Queue<Runnable> pendingCompiles = new ArrayDeque<Runnable>();
    private final Queue<Runnable> pendingUploads = new ArrayDeque<Runnable>();
    private final Map<ChunkPos, CachedRegion> regions = new HashMap<ChunkPos, CachedRegion>();
    private boolean valid = true;

    public CachedRegion getRenderRegion(ChunkPos chunkPos) {
        if (this.regions.containsKey(chunkPos)) {
            return this.regions.get(chunkPos);
        }
        CachedRegion region = new CachedRegion(chunkPos, this);
        this.regions.put(chunkPos, region);
        return region;
    }

    public CacheableBERenderingPipeline(ClientLevel level) {
        this.level = level;
    }

    public void runTasks() {
        while (!this.pendingCompiles.isEmpty() && this.valid) {
            this.pendingCompiles.poll().run();
        }
        while (!this.pendingUploads.isEmpty() && this.valid) {
            this.pendingUploads.poll().run();
        }
    }

    public static void updateLevel(ClientLevel level) {
        if (instance != null) {
            instance.releaseBuffers();
        }
        instance = new CacheableBERenderingPipeline(level);
    }

    public void blockRemoved(BlockEntity be) {
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
        if (renderer == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(be.getBlockPos());
        this.getRenderRegion(chunkPos).blockRemoved(be);
    }

    public void updateFromNetwork(ChunkPos chunkPos, Collection<BlockPos> entityPos) {
        this.getRenderRegion(chunkPos).replaceData(entityPos, this.level);
    }

    public void update(BlockEntity be) {
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
        if (renderer == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(be.getBlockPos());
        this.getRenderRegion(chunkPos).update(be);
    }

    public void submitUploadTask(Runnable task) {
        this.pendingUploads.add(task);
    }

    public void submitCompileTask(Runnable task) {
        this.pendingCompiles.add(task);
    }

    public void releaseBuffers() {
        this.regions.values().forEach(CachedRegion::releaseBuffers);
        this.valid = false;
    }

    public void render(Matrix4f frustumMatrix, Matrix4f projectionMatrix) {
        this.regions.values().forEach(it -> it.render(frustumMatrix, projectionMatrix));
    }

    @Nullable
    public static CacheableBERenderingPipeline getInstance() {
        return instance;
    }

    public void forcedUpdate(BlockPos pos) {
        this.getRenderRegion(new ChunkPos(pos)).forcedUpdate();
    }
}

