/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client.anvilcraft.rendering;

import com.yuushya.modelling.neoforge.client.anvilcraft.rendering.CacheableBERenderingPipeline;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CachedModeClient {
    public static final CachedModeClient INSTANCE = new CachedModeClient();
    private final Map<ChunkPos, List<BlockPos>> cachedModeData = new HashMap<ChunkPos, List<BlockPos>>();

    public boolean isCachedModeEnabledOn(BlockEntity be) {
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
        if (renderer == null) {
            return false;
        }
        return this.isCachedModeEnabledOn(be.getBlockPos());
    }

    public boolean isCachedModeEnabledOn(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!this.cachedModeData.containsKey(chunkPos)) {
            return false;
        }
        return this.cachedModeData.get(chunkPos).contains(pos);
    }

    public void updateCachedModeData(ChunkPos chunkPos, List<BlockPos> blockPosList) {
        this.cachedModeData.put(chunkPos, blockPosList);
        CacheableBERenderingPipeline.getInstance().updateFromNetwork(chunkPos, blockPosList);
    }
}

