/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client.anvilcraft.rendering;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import com.yuushya.modelling.neoforge.client.NeoItemBlockModel;
import com.yuushya.modelling.neoforge.client.anvilcraft.rendering.CacheableBERenderingPipeline;
import com.yuushya.modelling.neoforge.client.anvilcraft.rendering.FullyBufferedBufferSource;
import com.yuushya.modelling.utils.YuushyaUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CachedRegion {
    public static final RenderType TRANSLUCENT_MAIN = RenderType.create((String)"translucent_main", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)true, (RenderType.CompositeState)CachedRegion.translucentState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER));
    private final ChunkPos chunkPos;
    private final Map<RenderType, ByteBufferBuilder> sortBuffers = new HashMap<RenderType, ByteBufferBuilder>();
    private final Set<BlockEntity> blockEntities = new HashSet<BlockEntity>();
    private final CacheableBERenderingPipeline pipeline;
    private final Minecraft minecraft = Minecraft.getInstance();
    private final RandomSource random = RandomSource.create();
    private Map<RenderType, VertexBuffer> buffers = new HashMap<RenderType, VertexBuffer>();
    private Map<RenderType, MeshData.SortState> meshSortings = new HashMap<RenderType, MeshData.SortState>();
    private Reference2IntMap<RenderType> indexCountMap = new Reference2IntOpenHashMap();
    private ModelBlockRenderer.AmbientOcclusionFace aoFace = new ModelBlockRenderer.AmbientOcclusionFace();
    private static final Direction[] DIRECTIONS = Direction.values();
    @Nullable
    private RebuildTask lastRebuildTask;
    private boolean isEmpty = true;

    public CachedRegion(ChunkPos chunkPos, CacheableBERenderingPipeline pipeline) {
        this.chunkPos = chunkPos;
        this.pipeline = pipeline;
    }

    private static RenderType.CompositeState translucentState(RenderStateShard.ShaderStateShard state) {
        return RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(state).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.MAIN_TARGET).createCompositeState(true);
    }

    public void update(BlockEntity be) {
        if (this.lastRebuildTask != null) {
            this.lastRebuildTask.cancel();
        }
        boolean shouldRecompile = this.blockEntities.removeIf(BlockEntity::isRemoved);
        if (be.isRemoved()) {
            if (shouldRecompile |= this.blockEntities.remove(be)) {
                this.pipeline.submitCompileTask(new RebuildTask());
            }
            return;
        }
        if (shouldRecompile |= this.blockEntities.add(be)) {
            this.pipeline.submitCompileTask(new RebuildTask());
        }
    }

    public void blockRemoved(BlockEntity be) {
        boolean removedAny;
        if (this.lastRebuildTask != null) {
            this.lastRebuildTask.cancel();
        }
        boolean bl = removedAny = this.blockEntities.removeIf(BlockEntity::isRemoved) || this.blockEntities.remove(be);
        if (removedAny) {
            this.pipeline.submitCompileTask(new RebuildTask());
        }
    }

    public void render(Matrix4f frustumMatrix, Matrix4f projectionMatrix) {
        this.renderInternal(frustumMatrix, projectionMatrix, this.buffers.keySet());
    }

    public VertexBuffer getBuffer(RenderType renderType) {
        if (this.buffers.containsKey(renderType)) {
            return this.buffers.get(renderType);
        }
        VertexBuffer vb = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.buffers.put(renderType, vb);
        return vb;
    }

    private ByteBufferBuilder requestSortBuffer(RenderType renderType) {
        if (this.sortBuffers.containsKey(renderType)) {
            return this.sortBuffers.get(renderType);
        }
        ByteBufferBuilder builder = new ByteBufferBuilder(4096);
        this.sortBuffers.put(renderType, builder);
        return builder;
    }

    private void renderInternal(Matrix4f frustumMatrix, Matrix4f projectionMatrix, Collection<RenderType> renderTypes) {
        if (this.isEmpty) {
            return;
        }
        RenderSystem.enableBlend();
        Window window = Minecraft.getInstance().getWindow();
        Vec3 cameraPosition = this.minecraft.gameRenderer.getMainCamera().getPosition();
        int renderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance() * 16;
        Vec3 vec3 = new Vec3((double)(this.chunkPos.x * 16), cameraPosition.y, (double)(this.chunkPos.z * 16));
        if (cameraPosition.distanceTo(vec3) > (double)renderDistance) {
            return;
        }
        ArrayList<RenderType> renderingOrders = new ArrayList<RenderType>(renderTypes);
        renderingOrders.sort(Comparator.comparingInt(a -> a.sortOnUpload ? 1 : 0));
        for (RenderType renderType : renderingOrders) {
            VertexBuffer vb = this.buffers.get(renderType);
            if (vb == null) continue;
            this.renderLayer(renderType, vb, frustumMatrix, projectionMatrix, cameraPosition, window);
        }
    }

    public void releaseBuffers() {
        this.buffers.values().forEach(VertexBuffer::close);
        this.sortBuffers.values().forEach(ByteBufferBuilder::close);
    }

    private void renderLayer(RenderType renderType, VertexBuffer vertexBuffer, Matrix4f frustumMatrix, Matrix4f projectionMatrix, Vec3 cameraPosition, Window window) {
        ByteBufferBuilder.Result result;
        MeshData.SortState sortState;
        int indexCount = this.indexCountMap.getInt((Object)renderType);
        if (indexCount <= 0) {
            return;
        }
        renderType.setupRenderState();
        ShaderInstance shader = RenderSystem.getShader();
        shader.setDefaultUniforms(VertexFormat.Mode.QUADS, frustumMatrix, projectionMatrix, window);
        Uniform uniform = shader.CHUNK_OFFSET;
        if (uniform != null) {
            uniform.set((float)(-cameraPosition.x), (float)(-cameraPosition.y), (float)(-cameraPosition.z));
        }
        vertexBuffer.bind();
        if (renderType.sortOnUpload && (sortState = this.meshSortings.get(renderType)) != null && (result = sortState.buildSortedIndexBuffer(this.requestSortBuffer(renderType), VertexSorting.byDistance((Vector3f)cameraPosition.toVector3f()))) != null) {
            vertexBuffer.uploadIndexBuffer(result);
        }
        vertexBuffer.drawWithShader(frustumMatrix, projectionMatrix, shader);
        VertexBuffer.unbind();
        if (uniform != null) {
            uniform.set(0.0f, 0.0f, 0.0f);
        }
        renderType.clearRenderState();
    }

    public void replaceData(Collection<BlockPos> entityPos, ClientLevel clientLevel) {
        List<BlockEntity> blockEntities = entityPos.stream().map(arg_0 -> ((ClientLevel)clientLevel).getBlockEntity(arg_0)).filter(Objects::nonNull).toList();
        this.blockEntities.clear();
        this.blockEntities.addAll(blockEntities);
        this.pipeline.submitCompileTask(new RebuildTask());
    }

    public void forcedUpdate() {
        this.pipeline.submitCompileTask(new RebuildTask());
    }

    public <E extends BlockEntity> void addIfPossible(E blockEntity) {
        if (!this.blockEntities.contains(blockEntity)) {
            this.blockEntities.add(blockEntity);
            this.pipeline.submitCompileTask(new RebuildTask());
        }
    }

    private static float @NotNull [] getColorComponents(TransformItemData transformData, BakedModel model, BakedQuad bakedQuad) {
        Color color = new Color(transformData.color);
        if (model instanceof NeoItemBlockModel) {
            int[] vertices = bakedQuad.getVertices();
            color = new Color(QuadTransformers.toABGR((int)vertices[IQuadTransformer.STRIDE + IQuadTransformer.COLOR]));
        }
        float[] colorComponents = new float[3];
        color.getColorComponents(colorComponents);
        return colorComponents;
    }

    private void calculateShape(BlockAndTintGetter level, BlockState state, BlockPos pos, int[] vertices, Direction direction, @javax.annotation.Nullable float[] shape, BitSet shapeFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertices[i * 8]);
            float f7 = Float.intBitsToFloat(vertices[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(vertices[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (shape != null) {
            shape[Direction.WEST.get3DDataValue()] = f;
            shape[Direction.EAST.get3DDataValue()] = f3;
            shape[Direction.DOWN.get3DDataValue()] = f1;
            shape[Direction.UP.get3DDataValue()] = f4;
            shape[Direction.NORTH.get3DDataValue()] = f2;
            shape[Direction.SOUTH.get3DDataValue()] = f5;
            int j = DIRECTIONS.length;
            shape[Direction.WEST.get3DDataValue() + j] = 1.0f - f;
            shape[Direction.EAST.get3DDataValue() + j] = 1.0f - f3;
            shape[Direction.DOWN.get3DDataValue() + j] = 1.0f - f1;
            shape[Direction.UP.get3DDataValue() + j] = 1.0f - f4;
            shape[Direction.NORTH.get3DDataValue() + j] = 1.0f - f2;
            shape[Direction.SOUTH.get3DDataValue() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (direction) {
            case DOWN: {
                shapeFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                shapeFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
                break;
            }
            case UP: {
                shapeFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                shapeFlags.set(0, f1 == f4 && (f4 > 0.9999f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
                break;
            }
            case NORTH: {
                shapeFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                shapeFlags.set(0, f2 == f5 && (f2 < 1.0E-4f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
                break;
            }
            case SOUTH: {
                shapeFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                shapeFlags.set(0, f2 == f5 && (f5 > 0.9999f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
                break;
            }
            case WEST: {
                shapeFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                shapeFlags.set(0, f == f3 && (f < 1.0E-4f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
                break;
            }
            case EAST: {
                shapeFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                shapeFlags.set(0, f == f3 && (f3 > 0.9999f || state.isCollisionShapeFullBlock((BlockGetter)level, pos)));
            }
        }
    }

    private class RebuildTask
    implements Runnable {
        private boolean cancelled = false;

        private RebuildTask() {
        }

        @Override
        public void run() {
            CachedRegion.this.lastRebuildTask = this;
            int vertexSize = YuushyaUtils.vertexSize();
            PoseStack poseStack = new PoseStack();
            CachedRegion.this.isEmpty = true;
            FullyBufferedBufferSource bufferSource = new FullyBufferedBufferSource();
            Minecraft mc = Minecraft.getInstance();
            for (BlockEntity be : new ArrayList<BlockEntity>(CachedRegion.this.blockEntities)) {
                if (!(be instanceof ItemBlockEntity)) continue;
                ItemBlockEntity itemBlockEntity = (ItemBlockEntity)be;
                LocalPlayer localPlayer = mc.player;
                if (!(localPlayer instanceof LocalPlayer)) continue;
                LocalPlayer localPlayer2 = localPlayer;
                if (be.getLevel() == null) {
                    bufferSource.close();
                    return;
                }
                ItemRenderer renderer = mc.getItemRenderer();
                ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
                directions.add(null);
                float f = ((Direction)itemBlockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot();
                List<TransformItemData> transformDatas = itemBlockEntity.getTransformData();
                Level level = be.getLevel();
                BlockPos pos = be.getBlockPos();
                Boolean disableAO = (Boolean)be.getBlockState().getValue((Property)AbstractTransformBlock.ENABLE_AO);
                for (TransformItemData transformData : transformDatas) {
                    if (!transformData.isShown) continue;
                    ItemStack itemStack = transformData.itemStack;
                    BakedModel blockModel = renderer.getModel(itemStack, null, null, localPlayer2.getId());
                    for (BakedModel model : blockModel.getRenderPasses(itemStack, true)) {
                        BlockPos offset = pos.offset((int)(transformData.pos.x / 16.0), (int)(transformData.pos.y / 16.0), (int)(transformData.pos.z / 16.0));
                        if (model instanceof BuiltInModel) {
                            poseStack.pushPose();
                            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                            YuushyaUtils.scale(poseStack, transformData.scales);
                            YuushyaUtils.translate(poseStack, transformData.pos);
                            YuushyaUtils.rotate(poseStack, transformData.rot);
                            poseStack.translate(0.5f, 0.5f, 0.5f);
                            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)offset);
                            renderer.render(itemStack, ItemDisplayContext.NONE, false, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
                            poseStack.popPose();
                            continue;
                        }
                        for (Direction value : directions) {
                            float[] afloat = new float[DIRECTIONS.length * 2];
                            List blockModelQuads = model.getQuads(null, value, CachedRegion.this.random);
                            for (BakedQuad bakedQuad : blockModelQuads) {
                                poseStack.pushPose();
                                poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                                poseStack.translate(0.5f, 0.5f, 0.5f);
                                poseStack.mulPose(Axis.YP.rotationDegrees(-f));
                                poseStack.translate(-0.5f, -0.5f, -0.5f);
                                YuushyaUtils.scale(poseStack, transformData.scales);
                                YuushyaUtils.translate(poseStack, transformData.pos);
                                YuushyaUtils.rotate(poseStack, transformData.rot);
                                float[] colorComponents = CachedRegion.getColorComponents(transformData, model, bakedQuad);
                                BitSet bitset = new BitSet(3);
                                CachedRegion.this.calculateShape((BlockAndTintGetter)level, be.getBlockState(), offset, bakedQuad.getVertices(), bakedQuad.getDirection(), afloat, bitset);
                                CachedRegion.this.aoFace.calculate((BlockAndTintGetter)level, be.getBlockState(), offset, bakedQuad.getDirection(), afloat, bitset, bakedQuad.isShade());
                                if (disableAO.booleanValue()) {
                                    bufferSource.getBuffer(TRANSLUCENT_MAIN).putBulkData(poseStack.last(), bakedQuad, CachedRegion.this.aoFace.brightness, colorComponents[0], colorComponents[1], colorComponents[2], 1.0f, CachedRegion.this.aoFace.lightmap, OverlayTexture.NO_OVERLAY, true);
                                } else {
                                    int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos.offset((int)(transformData.pos.x / 16.0), (int)(transformData.pos.y / 16.0), (int)(transformData.pos.z / 16.0)));
                                    bufferSource.getBuffer(TRANSLUCENT_MAIN).putBulkData(poseStack.last(), bakedQuad, colorComponents[0], colorComponents[1], colorComponents[2], 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
                                }
                                poseStack.popPose();
                            }
                        }
                    }
                }
            }
            CachedRegion.this.isEmpty = bufferSource.isEmpty();
            bufferSource.upload(CachedRegion.this::getBuffer, CachedRegion.this::requestSortBuffer, CachedRegion.this.pipeline::submitUploadTask);
            CachedRegion.this.meshSortings = bufferSource.getMeshSorts();
            CachedRegion.this.indexCountMap = bufferSource.getIndexCountMap();
            CachedRegion.this.lastRebuildTask = null;
        }

        void cancel() {
            this.cancelled = true;
        }
    }
}

