/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client.anvilcraft.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FullyBufferedBufferSource
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private final Map<RenderType, ByteBufferBuilder> byteBuffers = new HashMap<RenderType, ByteBufferBuilder>();
    private final Map<RenderType, BufferBuilder> bufferBuilders = new HashMap<RenderType, BufferBuilder>();
    private final Reference2IntMap<RenderType> indexCountMap = new Reference2IntOpenHashMap();
    private final Map<RenderType, MeshData.SortState> meshSorts = new HashMap<RenderType, MeshData.SortState>();
    private final Map<RenderType, RenderType> cachedRenderTypeConvertions = new HashMap<RenderType, RenderType>();

    public FullyBufferedBufferSource() {
        super(null, null);
    }

    private ByteBufferBuilder getByteBuffer(RenderType renderType) {
        return this.byteBuffers.computeIfAbsent(renderType, it -> new ByteBufferBuilder(786432));
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        return (VertexConsumer)this.bufferBuilders.computeIfAbsent(this.forceUseBlockRenderTypes(renderType), it -> new BufferBuilder(this.getByteBuffer(this.forceUseBlockRenderTypes(renderType)), it.mode, it.format));
    }

    private RenderType forceUseBlockRenderTypes(RenderType renderType) {
        if (renderType.format == DefaultVertexFormat.NEW_ENTITY && renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            return this.cachedRenderTypeConvertions.computeIfAbsent(renderType, it -> this.createBlockRenderType(compositeRenderType));
        }
        return renderType;
    }

    private RenderType createBlockRenderType(RenderType.CompositeRenderType renderType) {
        RenderType.CompositeState state = renderType.state();
        return RenderType.create((String)"yuushya_modelling:generated", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)renderType.mode, (int)786432, (boolean)renderType.affectsCrumbling, (boolean)renderType.sortOnUpload, (RenderType.CompositeState)RenderType.CompositeState.builder().setCullState(state.cullState).setOutputState(RenderStateShard.MAIN_TARGET).setShaderState(RenderStateShard.RENDERTYPE_CUTOUT_SHADER).setTextureState(state.textureState).setLightmapState(RenderStateShard.LIGHTMAP).setTransparencyState(state.transparencyState).createCompositeState(false));
    }

    public boolean isEmpty() {
        return !this.bufferBuilders.isEmpty() && this.bufferBuilders.values().stream().noneMatch(it -> it.vertices > 0);
    }

    public void endBatch(RenderType renderType) {
    }

    public void endLastBatch() {
    }

    public void endBatch() {
    }

    public void upload(Function<RenderType, VertexBuffer> vertexBufferGetter, Function<RenderType, ByteBufferBuilder> byteBufferSupplier, Consumer<Runnable> runner) {
        for (RenderType renderType : this.bufferBuilders.keySet()) {
            runner.accept(() -> {
                BufferBuilder bufferBuilder = this.bufferBuilders.get(renderType);
                ByteBufferBuilder byteBuffer = this.byteBuffers.get(renderType);
                int compiledVertices = bufferBuilder.vertices * renderType.format.getVertexSize();
                if (compiledVertices >= 0) {
                    MeshData mesh = bufferBuilder.build();
                    this.indexCountMap.put((Object)renderType, renderType.mode.indexCount(bufferBuilder.vertices));
                    if (mesh != null) {
                        if (renderType.sortOnUpload) {
                            MeshData.SortState sortState = mesh.sortQuads((ByteBufferBuilder)byteBufferSupplier.apply(renderType), RenderSystem.getVertexSorting());
                            this.meshSorts.put(renderType, sortState);
                        }
                        VertexBuffer vertexBuffer = (VertexBuffer)vertexBufferGetter.apply(renderType);
                        vertexBuffer.bind();
                        vertexBuffer.upload(mesh);
                        VertexBuffer.unbind();
                    }
                }
                byteBuffer.close();
                this.bufferBuilders.remove(renderType);
                this.byteBuffers.remove(renderType);
            });
        }
    }

    public void close(RenderType renderType) {
        ByteBufferBuilder builder = this.byteBuffers.get(renderType);
        builder.close();
    }

    @Override
    public void close() {
        this.byteBuffers.keySet().forEach(this::close);
    }

    @Generated
    public Reference2IntMap<RenderType> getIndexCountMap() {
        return this.indexCountMap;
    }

    @Generated
    public Map<RenderType, MeshData.SortState> getMeshSorts() {
        return this.meshSorts;
    }
}

