/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.neoforge.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.yuushya.modelling.registries.YuushyaRegistries;
import java.awt.Color;
import java.nio.ByteBuffer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class PickColorOverlay
implements LayeredDraw.Layer {
    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel world = minecraft.level;
        Options options = minecraft.options;
        LocalPlayer player = minecraft.player;
        if (player == null || world == null || options.hideGui) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        int guiWidth = guiGraphics.guiWidth() / 2;
        int guiHeight = guiGraphics.guiHeight() / 2;
        if (mainHandItem.is(YuushyaRegistries.ITEMS.get("color_picker_item"))) {
            Window window = Minecraft.getInstance().getWindow();
            int width = window.getScreenWidth();
            int height = window.getScreenHeight();
            int centerX = width / 2;
            int centerY = height / 2;
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)4);
            GL11.glReadPixels((int)centerX, (int)centerY, (int)1, (int)1, (int)6408, (int)5121, (ByteBuffer)buffer);
            int r = 255 - buffer.get(0) & 0xFF;
            int g = 255 - buffer.get(1) & 0xFF;
            int b = 255 - buffer.get(2) & 0xFF;
            int color = 0xFF000000 | r << 16 | g << 8 | b;
            guiGraphics.fill(guiWidth - 35, guiHeight - 35, guiWidth - 10, guiHeight - 10, Color.LIGHT_GRAY.getRGB());
            guiGraphics.fill(guiWidth - 33, guiHeight - 33, guiWidth - 12, guiHeight - 12, color);
            Integer i = (Integer)mainHandItem.get((DataComponentType)YuushyaRegistries.COLOR_DATA.get());
            if (i != null) {
                guiGraphics.fill(guiWidth + 10, guiHeight - 35, guiWidth + 35, guiHeight - 10, Color.LIGHT_GRAY.getRGB());
                guiGraphics.fill(guiWidth + 12, guiHeight - 33, guiWidth + 33, guiHeight - 12, i | 0xFF000000);
            }
        }
    }
}

