/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record ItemStackPacket(BlockPos blockPos, int slot, ItemStack itemStack) implements CustomPacketPayload
{
    public static final ResourceLocation ITEM_DATA_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"item_data_packet");
    public static final CustomPacketPayload.Type<ItemStackPacket> TYPE = new CustomPacketPayload.Type(ITEM_DATA_PACKET_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ItemStackPacket::blockPos, (StreamCodec)ByteBufCodecs.VAR_INT, ItemStackPacket::slot, (StreamCodec)ItemStack.STREAM_CODEC, ItemStackPacket::itemStack, ItemStackPacket::new);

    public static void handler(ItemStackPacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            BlockEntity patt0$temp;
            ServerLevel serverLevel;
            Level level = ctx.getPlayer().level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).hasChunkAt(packet.blockPos) && (patt0$temp = serverLevel.getBlockEntity(packet.blockPos)) instanceof ItemBlockEntity) {
                ItemBlockEntity itemBlockEntity = (ItemBlockEntity)patt0$temp;
                ItemTransformType.ITEM_STACK.modify(itemBlockEntity, packet.slot, packet.itemStack);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

