/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.blockentity.itemblock.ItemBlock;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import com.yuushya.modelling.blockentity.transformData.ItemTransformType;
import com.yuushya.modelling.network.NeoForgeCodecs;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record ItemTransformDataOncePacket(BlockPos blockPos, ItemTransformType transformType, int slot, double number) implements CustomPacketPayload
{
    public static final ResourceLocation ITEM_TRANSFORM_DATA_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"item_transform_data_packet");
    public static final CustomPacketPayload.Type<ItemTransformDataOncePacket> TYPE = new CustomPacketPayload.Type(ITEM_TRANSFORM_DATA_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, ItemTransformDataOncePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ItemTransformDataOncePacket::blockPos, NeoForgeCodecs.enumCodec(ItemTransformType.class), ItemTransformDataOncePacket::transformType, (StreamCodec)ByteBufCodecs.VAR_INT, ItemTransformDataOncePacket::slot, (StreamCodec)ByteBufCodecs.DOUBLE, ItemTransformDataOncePacket::number, ItemTransformDataOncePacket::new);

    public static void sendToServerSideSuccess(BlockPos blockPos) {
        ItemTransformDataOncePacket.sendToServerSide(blockPos, 0, ItemTransformType.SUCCESS, 0.0);
    }

    public static void sendToServerSide(BlockPos blockPos, int slot, ItemTransformType type, double number) {
        NetworkManager.sendToServer((CustomPacketPayload)new ItemTransformDataOncePacket(blockPos, type, slot, number));
    }

    public static void handler(ItemTransformDataOncePacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            ServerLevel serverLevel;
            Level level = ctx.getPlayer().level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).hasChunkAt(packet.blockPos) && serverLevel.getBlockState(packet.blockPos).getBlock() instanceof ItemBlock) {
                BlockEntity blockEntity = serverLevel.getBlockEntity(packet.blockPos);
                if (!(blockEntity instanceof ItemBlockEntity)) {
                    return;
                }
                ItemBlockEntity itemBlockEntity = (ItemBlockEntity)blockEntity;
                packet.transformType.modify(itemBlockEntity, packet.slot, packet.number);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<ItemTransformDataOncePacket> type() {
        return TYPE;
    }
}

