/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.YuushyaClient;
import com.yuushya.modelling.command.ReloadModelCommand;
import com.yuushya.modelling.gui.engrave.EngraveBlockResultLoader;
import com.yuushya.modelling.gui.engrave.EngraveItemResultLoader;
import com.yuushya.modelling.network.NeoForgeCodecs;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ReloadModelPacket(ReloadModelCommand.ReloadType reloadType) implements CustomPacketPayload
{
    public static final ResourceLocation RELOAD_MODEL_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"reload_model_packet");
    public static final CustomPacketPayload.Type<ReloadModelPacket> TYPE = new CustomPacketPayload.Type(RELOAD_MODEL_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, ReloadModelPacket> STREAM_CODEC = StreamCodec.composite(NeoForgeCodecs.enumCodec(ReloadModelCommand.ReloadType.class), ReloadModelPacket::reloadType, ReloadModelPacket::new);

    public static void handler(ReloadModelPacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            Level level = ctx.getPlayer().level();
            if (level instanceof ClientLevel) {
                ClientLevel client = (ClientLevel)level;
                switch (packet.reloadType) {
                    case BLOCKS: {
                        EngraveBlockResultLoader.SHOWBLOCK_ITEM_MAP.clear();
                        EngraveBlockResultLoader.load(client);
                        break;
                    }
                    case ITEMS: {
                        EngraveItemResultLoader.ITEMBLOCK_ITEM_MAP.clear();
                        EngraveItemResultLoader.load(client);
                        break;
                    }
                    case ALL: {
                        YuushyaClient.load();
                    }
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

