/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.gui.engrave.EngraveMenu;
import com.yuushya.modelling.gui.engrave.IEngraveResult;
import com.yuushya.modelling.registries.YuushyaRegistries;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public record TransformDataListPacket(CompoundTag tag) implements CustomPacketPayload
{
    public static final ResourceLocation TRANSFORM_DATA_LIST_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"transform_data_list_packet");
    public static final CustomPacketPayload.Type<TransformDataListPacket> TYPE = new CustomPacketPayload.Type(TRANSFORM_DATA_LIST_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, TransformDataListPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, TransformDataListPacket::tag, TransformDataListPacket::new);
    public static final Set<String> SendingCache = new HashSet<String>();
    private static final Map<String, ItemStack> HandlingCache = new HashMap<String, ItemStack>();

    public static void updateSendingCache(String name) {
        SendingCache.remove(name);
    }

    public static void sendToServerSide(IEngraveResult itemResult) {
        CompoundTag tag;
        String name = itemResult.getName();
        if (SendingCache.contains(name)) {
            tag = new CompoundTag();
        } else {
            ItemStack itemStack = itemResult.getResultItem();
            CustomData data = (CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
            tag = data.copyTag();
        }
        tag.putString("ItemName", name);
        NetworkManager.sendToServer((CustomPacketPayload)new TransformDataListPacket(tag));
    }

    public static void handler(TransformDataListPacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            Player player = ctx.getPlayer();
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof EngraveMenu) {
                EngraveMenu menu = (EngraveMenu)abstractContainerMenu;
                if (!menu.stillValid(player)) {
                    return;
                }
                String name = packet.tag.getString("ItemName");
                String hash = player.getStringUUID() + name;
                if (!packet.tag.contains("Blocks") && HandlingCache.containsKey(hash)) {
                    menu.setupResultSlotServer(HandlingCache.get(hash));
                } else {
                    String itemType = menu.isUsingItemRecipes() ? "itemblock" : "showblock";
                    ItemStack itemStack = ((Item)YuushyaRegistries.ITEMS.get(itemType).get()).getDefaultInstance();
                    itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)name));
                    itemStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)packet.tag));
                    HandlingCache.put(hash, itemStack);
                    menu.setupResultSlotServer(itemStack);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<TransformDataListPacket> type() {
        return TYPE;
    }
}

