/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.blockentity.transformData.TransformType;
import com.yuushya.modelling.network.NeoForgeCodecs;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record TransformDataOncePacket(BlockPos blockPos, TransformType transformType, int slot, double number) implements CustomPacketPayload
{
    public static final ResourceLocation TRANSFORM_DATA_PACKET_ID = ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"transform_data_packet");
    public static final CustomPacketPayload.Type<TransformDataOncePacket> TYPE = new CustomPacketPayload.Type(TRANSFORM_DATA_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, TransformDataOncePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TransformDataOncePacket::blockPos, NeoForgeCodecs.enumCodec(TransformType.class), TransformDataOncePacket::transformType, (StreamCodec)ByteBufCodecs.VAR_INT, TransformDataOncePacket::slot, (StreamCodec)ByteBufCodecs.DOUBLE, TransformDataOncePacket::number, TransformDataOncePacket::new);

    public static void handler(TransformDataOncePacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            ServerLevel serverLevel;
            Level level = ctx.getPlayer().level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).hasChunkAt(packet.blockPos) && serverLevel.getBlockState(packet.blockPos).getBlock() instanceof ShowBlock) {
                BlockEntity blockEntity = serverLevel.getBlockEntity(packet.blockPos);
                if (!(blockEntity instanceof ShowBlockEntity)) {
                    return;
                }
                ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
                packet.transformType.modify(showBlockEntity, packet.slot, packet.number);
            }
        });
    }

    public static void sendToServerSideSuccess(BlockPos blockPos) {
        TransformDataOncePacket.sendToServerSide(blockPos, 0, TransformType.SUCCESS, 0.0);
    }

    public static void sendToServerSide(BlockPos blockPos, int slot, TransformType type, double number) {
        NetworkManager.sendToServer((CustomPacketPayload)new TransformDataOncePacket(blockPos, type, slot, number));
    }

    @NotNull
    public CustomPacketPayload.Type<TransformDataOncePacket> type() {
        return TYPE;
    }
}

