/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.network;

import com.yuushya.modelling.blockentity.AbstractTransformBlock;
import com.yuushya.modelling.blockentity.itemblock.ItemBlockEntity;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public record UpdateAOPacket(boolean enableAO, BlockPos blockPos) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, UpdateAOPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, UpdateAOPacket::enableAO, (StreamCodec)BlockPos.STREAM_CODEC, UpdateAOPacket::blockPos, UpdateAOPacket::new);
    public static final CustomPacketPayload.Type<UpdateAOPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"yuushya_modelling", (String)"diable_ao_packet"));

    public static void handler(UpdateAOPacket packet, NetworkManager.PacketContext ctx) {
        ctx.queue(() -> {
            ServerLevel serverLevel;
            BlockEntity blockEntity;
            Level level = ctx.getPlayer().level();
            if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(packet.blockPos)) instanceof ItemBlockEntity) {
                level.setBlockAndUpdate(blockEntity.getBlockPos(), (BlockState)blockEntity.getBlockState().setValue((Property)AbstractTransformBlock.ENABLE_AO, (Comparable)Boolean.valueOf(packet.enableAO)));
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

