/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yuushya.modelling.blockentity.transformData.TransformBlockData;
import com.yuushya.modelling.blockentity.transformData.TransformItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ShareUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();

    public static int getABGR(int rgb) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static String transfer(List<TransformBlockData> transformDataList) {
        ShareBlockInformation shareBlockInformation = ShareBlockInformation.from(transformDataList);
        return GSON.toJson((Object)shareBlockInformation, ShareBlockInformation.class);
    }

    public static String transferItems(List<TransformItemData> transformDataList) {
        ShareItemInformation shareInformation = ShareItemInformation.from(transformDataList);
        return GSON.toJson((Object)shareInformation, ShareItemInformation.class);
    }

    public static ShareBlockInformation from(String json) {
        return (ShareBlockInformation)GSON.fromJson(json, ShareBlockInformation.class);
    }

    public static ShareItemInformation fromItems(String json) {
        return (ShareItemInformation)GSON.fromJson(json, ShareItemInformation.class);
    }

    public static CompoundTag jsonToCompoundTag(JsonElement json) {
        DataResult result = CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
        return result.result().orElse(new CompoundTag());
    }

    public record ShareBlockInformation(Set<String> mods, List<ShareData> blocks) {
        public static ShareBlockInformation from(List<TransformBlockData> transformDataList) {
            HashSet<String> modIds = new HashSet<String>();
            ArrayList<ShareData> shareDataList = new ArrayList<ShareData>();
            for (TransformBlockData data : transformDataList) {
                String namespace = BuiltInRegistries.BLOCK.getKey((Object)data.blockState.getBlock()).getNamespace();
                if (!"minecraft".equals(namespace)) {
                    modIds.add(namespace);
                }
                shareDataList.add(ShareData.from(data));
            }
            return new ShareBlockInformation(modIds, shareDataList);
        }

        public void transfer(List<TransformBlockData> transformDataList) {
            if (!transformDataList.isEmpty()) {
                transformDataList.clear();
            }
            for (ShareData data : this.blocks) {
                transformDataList.add(data.transfer());
            }
        }

        public record ShareData(List<Double> pos, List<Float> rot, List<Float> scales, ShareBlockState blockState, boolean isShown) {
            public static ShareData from(TransformBlockData data) {
                return new ShareData(List.of(Double.valueOf(data.pos.x), Double.valueOf(data.pos.y), Double.valueOf(data.pos.z)), List.of(Float.valueOf(data.rot.x), Float.valueOf(data.rot.y), Float.valueOf(data.rot.z)), List.of(Float.valueOf(data.scales.x), Float.valueOf(data.scales.y), Float.valueOf(data.scales.z)), ShareBlockState.from(data.blockState), data.isShown);
            }

            public TransformBlockData transfer() {
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                return new TransformBlockData(new Vector3d(this.pos.get(0).doubleValue(), this.pos.get(1).doubleValue(), this.pos.get(2).doubleValue()), new Vector3f(this.rot.get(0).floatValue(), this.rot.get(1).floatValue(), this.rot.get(2).floatValue()), new Vector3f(this.scales.get(0).floatValue(), this.scales.get(1).floatValue(), this.scales.get(2).floatValue()), this.blockState.transfer(), this.isShown);
            }

            public record ShareBlockState(String name, Map<String, String> properties) {
                public static ShareBlockState from(BlockState state) {
                    String name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
                    Map map = state.getValues();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (Map.Entry entry : map.entrySet()) {
                        Property property = (Property)entry.getKey();
                        Comparable value = (Comparable)entry.getValue();
                        properties.put(property.getName(), ShareBlockState.getName(property, value));
                    }
                    return new ShareBlockState(name, properties);
                }

                private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, String value) {
                    return (S)property.getValue(value).map(t -> (StateHolder)stateHolder.setValue(property, t)).orElse(stateHolder);
                }

                private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<T> value) {
                    return property.getName(value);
                }

                public BlockState transfer() {
                    Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)this.name));
                    BlockState blockState = block.defaultBlockState();
                    StateDefinition stateDefinition = block.getStateDefinition();
                    for (String string : this.properties.keySet()) {
                        Property property = stateDefinition.getProperty(string);
                        if (property == null) continue;
                        blockState = ShareBlockState.setValueHelper(blockState, property, this.properties.get(string));
                    }
                    return blockState;
                }
            }
        }
    }

    public record ShareItemInformation(Set<String> mods, List<ItemShareData> items) {
        public static ShareItemInformation from(List<TransformItemData> transformDataList) {
            HashSet<String> modIds = new HashSet<String>();
            ArrayList<ItemShareData> shareDataList = new ArrayList<ItemShareData>();
            for (TransformItemData data : transformDataList) {
                String namespace = BuiltInRegistries.ITEM.getKey((Object)data.itemStack.getItem()).getNamespace();
                if (!"minecraft".equals(namespace)) {
                    modIds.add(namespace);
                }
                shareDataList.add(ItemShareData.from(data));
            }
            return new ShareItemInformation(modIds, shareDataList);
        }

        public void transferItems(List<TransformItemData> transformDataList) {
            if (!transformDataList.isEmpty()) {
                transformDataList.clear();
            }
            for (ItemShareData data : this.items) {
                transformDataList.add(data.transfer());
            }
        }

        public record ItemShareData(List<Double> pos, List<Float> rot, List<Float> scales, ShareItemStack itemStack, int color, boolean isShown) {
            public static ItemShareData from(TransformItemData data) {
                return new ItemShareData(List.of(Double.valueOf(data.pos.x()), Double.valueOf(data.pos.y()), Double.valueOf(data.pos.z())), List.of(Float.valueOf(data.rot.x()), Float.valueOf(data.rot.y()), Float.valueOf(data.rot.z())), List.of(Float.valueOf(data.scales.x()), Float.valueOf(data.scales.y()), Float.valueOf(data.scales.z())), ShareItemStack.from(data.itemStack), data.color, data.isShown);
            }

            public TransformItemData transfer() {
                ArrayList<Double> posList = new ArrayList<Double>(this.pos);
                ArrayList<Float> rotList = new ArrayList<Float>(this.rot);
                ArrayList<Float> scalesList = new ArrayList<Float>(this.scales);
                posList.add(0.0);
                posList.add(0.0);
                posList.add(0.0);
                rotList.add(Float.valueOf(0.0f));
                rotList.add(Float.valueOf(0.0f));
                rotList.add(Float.valueOf(0.0f));
                scalesList.add(Float.valueOf(1.0f));
                scalesList.add(Float.valueOf(1.0f));
                scalesList.add(Float.valueOf(1.0f));
                return new TransformItemData(new Vector3d(((Double)posList.get(0)).doubleValue(), ((Double)posList.get(1)).doubleValue(), ((Double)posList.get(2)).doubleValue()), new Vector3f(((Float)rotList.get(0)).floatValue(), ((Float)rotList.get(1)).floatValue(), ((Float)rotList.get(2)).floatValue()), new Vector3f(((Float)scalesList.get(0)).floatValue(), ((Float)scalesList.get(1)).floatValue(), ((Float)scalesList.get(2)).floatValue()), this.itemStack.transfer(), this.color, this.isShown);
            }

            public record ShareItemStack(String name, JsonElement jsonElement) {
                public static ShareItemStack from(ItemStack stack) {
                    ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    Tag tag = (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).result().orElse(new CompoundTag());
                    String asString = tag.getAsString();
                    JsonPrimitive jsonPrimitive = new JsonPrimitive(asString);
                    return new ShareItemStack(itemId.toString(), (JsonElement)jsonPrimitive);
                }

                public ItemStack transfer() {
                    CompoundTag compoundTag;
                    String snbtFromJson = this.jsonElement.getAsJsonPrimitive().getAsString();
                    try {
                        compoundTag = TagParser.parseTag((String)snbtFromJson);
                    }
                    catch (Exception e) {
                        compoundTag = new CompoundTag();
                    }
                    Pair itemStackJsonElementPair = ItemStack.OPTIONAL_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag).result().orElse(Pair.of((Object)ItemStack.EMPTY, (Object)new CompoundTag()));
                    return (ItemStack)itemStackJsonElementPair.getFirst();
                }
            }
        }
    }

    public static class StringSerialization {
        public static CompoundTag transfer(String string) throws CommandSyntaxException {
            return TagParser.parseTag((String)string);
        }

        public static String from(CompoundTag tag) {
            return tag.getAsString();
        }
    }
}

