/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class YuushyaUtils {
    public static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> propertyValueMap) {
            if (propertyValueMap == null) {
                return "<NULL>";
            }
            Property<?> property = propertyValueMap.getKey();
            return property.getName() + "=" + this.getName(property, propertyValueMap.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
            return property.getName(value);
        }
    };

    public static int vertexSize() {
        return DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    }

    public static void scale(PoseStack arg, Vector3f scales) {
        if (scales.x() != 1.0f || scales.y() != 1.0f || scales.z() != 1.0f) {
            arg.translate(0.5, 0.5, 0.5);
            arg.scale(scales.x(), scales.y(), scales.z());
            arg.translate(-0.5, -0.5, -0.5);
        }
    }

    public static void translateAfterScale(PoseStack arg, Vector3d pos, Vector3f scales) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.translate(pos.x * (double)scales.x() / 16.0, pos.y * (double)scales.y() / 16.0, pos.z * (double)scales.z() / 16.0);
        }
    }

    public static void translate(PoseStack arg, Vector3d pos) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.translate(pos.x / 16.0, pos.y / 16.0, pos.z / 16.0);
        }
    }

    public static void rotate(PoseStack arg, Vector3f rot) {
        float roll = rot.z();
        float yaw = rot.y();
        float pitch = rot.x();
        if (roll != 0.0f || yaw != 0.0f || pitch != 0.0f) {
            arg.translate(0.5, 0.5, 0.5);
            if (roll != 0.0f) {
                arg.mulPose(Axis.ZP.rotationDegrees(roll));
            }
            if (yaw != 0.0f) {
                arg.mulPose(Axis.YP.rotationDegrees(yaw));
            }
            if (pitch != 0.0f) {
                arg.mulPose(Axis.XP.rotationDegrees(pitch));
            }
            arg.translate(-0.5, -0.5, -0.5);
        }
    }

    public static void mirror(Vector3d pos, Quaternionf rot, MirrorFace face) {
        switch (face.ordinal()) {
            case 0: {
                pos.x = -pos.x;
                rot.x = -rot.x;
                rot.w = -rot.w;
                break;
            }
            case 1: {
                pos.y = -pos.y;
                rot.y = -rot.y;
                rot.w = -rot.w;
                break;
            }
            case 2: {
                pos.z = -pos.z;
                rot.z = -rot.z;
                rot.w = -rot.w;
            }
        }
    }

    public static double normalizeAngle(double degrees) {
        if ((degrees %= 360.0) < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    public static int encodeTintWithState(int tint, BlockState state) {
        return Block.getId((BlockState)state) << 8 | tint;
    }

    public static BlockState getBlockState(BlockState blockState, LevelAccessor world, BlockPos blockPos) {
        if (blockState.getBlock() instanceof ShowBlock) {
            ShowBlockEntity blockEntity = (ShowBlockEntity)world.getBlockEntity(blockPos);
            return blockEntity.getTransFormDataNow().blockState;
        }
        return blockState;
    }

    public static String getBlockStateProperties(BlockState blockState) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!blockState.getValues().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(blockState.getValues().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static ListTag toListTag(Number ... values) {
        ListTag listTag = new ListTag();
        Arrays.stream(values).toList().forEach(e -> {
            if (e instanceof Float) {
                Float e1 = (Float)e;
                listTag.add((Object)FloatTag.valueOf((float)e1.floatValue()));
            } else if (e instanceof Double) {
                Double e1 = (Double)e;
                listTag.add((Object)DoubleTag.valueOf((double)e1));
            }
        });
        return listTag;
    }

    public static ListTag toDoubleListTag(Vector3f values) {
        ListTag listTag = new ListTag();
        listTag.add((Object)DoubleTag.valueOf((double)values.x()));
        listTag.add((Object)DoubleTag.valueOf((double)values.y()));
        listTag.add((Object)DoubleTag.valueOf((double)values.z()));
        return listTag;
    }

    public static CompoundTag itemStackTag(ItemStack stack, HolderLookup.Provider registries) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        CompoundTag compoundTag = new CompoundTag();
        return (CompoundTag)stack.save(registries, (Tag)compoundTag);
    }

    public static BlockState readBlockState(CompoundTag tag) {
        if (!tag.contains("Name", 8)) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("Name")));
        BlockState blockState = block.defaultBlockState();
        if (tag.contains("Properties", 10)) {
            CompoundTag compoundTag = tag.getCompound("Properties");
            StateDefinition stateDefinition = block.getStateDefinition();
            for (String string : compoundTag.getAllKeys()) {
                Property property = stateDefinition.getProperty(string);
                if (property == null) continue;
                blockState = YuushyaUtils.setValueHelper(blockState, property, string, compoundTag, tag);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, String propertyName, CompoundTag propertiesTag, CompoundTag blockStateTag) {
        Optional optional = property.getValue(propertiesTag.getString(propertyName));
        return (S)optional.map(t -> (StateHolder)stateHolder.setValue(property, t)).orElse(stateHolder);
    }

    public static enum MirrorFace {
        X,
        Y,
        Z;

    }
}

