/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2498;
import net.minecraft.class_2680;

public class AcousticsPlayer
implements AcousticLibrary {
    private final Map<String, Acoustic> acoustics = new Object2ObjectOpenHashMap();
    private final SoundPlayer soundPlayer;

    public AcousticsPlayer(SoundPlayer soundPlayer) {
        this.soundPlayer = soundPlayer;
    }

    @Override
    public void addAcoustic(String name, Acoustic acoustic) {
        if (this.acoustics.put(name, acoustic) != null) {
            PresenceFootsteps.logger.info("Duplicate acoustic: " + name);
        }
    }

    @Override
    public void playStep(Association association, State event, Options options) {
        if (association.isSilent()) {
            return;
        }
        if (association.dry().isResult() && !association.dry().isVanilla()) {
            this.playAcoustic(association.source(), association.dry(), event, options);
        } else {
            this.playVanillaStep(association, options);
        }
        if (association.wet().isEmitter() && Options.WET_VOLUME_OPTIONS.get("volume_percentage") > 0.1f) {
            this.playAcoustic(association.source(), association.wet(), event, options.and(Options.WET_VOLUME_OPTIONS));
        }
        if (association.foliage().isEmitter() && Options.FOLIAGE_VOLUME_OPTIONS.get("volume_percentage") > 0.1f) {
            this.playAcoustic(association.source(), association.foliage(), event, options.and(Options.FOLIAGE_VOLUME_OPTIONS));
        }
    }

    private void playVanillaStep(Association association, Options options) {
        if (association.state().method_51176()) {
            return;
        }
        class_2498 soundType = association.state().method_26231();
        class_2680 above = association.source().method_73183().method_8320(association.pos().method_10084());
        if (above.method_27852(class_2246.field_10477)) {
            soundType = above.method_26231();
        }
        this.soundPlayer.playSound(association.source(), soundType.method_10594().comp_3319().toString(), soundType.method_10597() * 0.15f, soundType.method_10599(), options);
    }

    @Override
    public void playAcoustic(class_1309 location, SoundsKey sounds, State event, Options inputOptions) {
        for (String acousticName : sounds.names()) {
            Acoustic acoustic = this.acoustics.get(acousticName);
            if (acoustic == null) {
                PresenceFootsteps.logger.warn("Tried to play a missing acoustic: " + acousticName);
                continue;
            }
            acoustic.playSound(this.soundPlayer, location, event, inputOptions);
        }
    }

    @Override
    public void think() {
        this.soundPlayer.think();
    }
}

