/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSubstrateLookup<T>
implements Lookup.DataSegment<T> {
    private final Map<String, Map<class_2960, Optional<SoundsKey>>> substrates = new Object2ObjectLinkedOpenHashMap();

    protected AbstractSubstrateLookup(JsonObject json) {
        json.entrySet().forEach(entry -> {
            String[] split = ((String)entry.getKey()).trim().split("@");
            String primitive = split[0];
            String substrate = split.length > 1 ? split[1] : "";
            this.substrates.computeIfAbsent(substrate, s -> new Object2ObjectLinkedOpenHashMap()).put(class_2960.method_60654((String)primitive), Optional.of(SoundsKey.of(((JsonElement)entry.getValue()).getAsString())));
        });
    }

    protected abstract class_2960 getId(T var1);

    @Override
    public Optional<SoundsKey> getAssociation(@Nullable T key, String substrate) {
        if (key == null) {
            return Optional.empty();
        }
        class_2960 id = this.getId(key);
        return this.getSubstrateMap(id, substrate).getOrDefault(id, Optional.empty());
    }

    @Nullable
    protected Map<class_2960, Optional<SoundsKey>> getSubstrateMap(class_2960 id, String substrate) {
        Map<class_2960, Optional<SoundsKey>> primitives = this.substrates.get(substrate);
        if (primitives != null) {
            return primitives;
        }
        primitives = this.substrates.get("break_" + id.method_12832());
        if (primitives != null) {
            return primitives;
        }
        return this.substrates.getOrDefault("", Map.of());
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public boolean contains(T key) {
        class_2960 primitive = this.getId(key);
        for (Map<class_2960, Optional<SoundsKey>> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T key, String substrate) {
        return this.substrates.containsKey(substrate) && this.substrates.get(substrate).containsKey(this.getId(key));
    }

    @Override
    public boolean isEmpty() {
        return this.substrates.isEmpty();
    }
}

