/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.fabric;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.Payload;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.C2SChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.C2SMessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.MessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.fabric.FabricChannel;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import com.misterpemodder.shulkerboxtooltip.impl.util.EnvironmentUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;

class FabricC2SChannel<T>
extends FabricChannel<T>
implements C2SChannel<T> {
    @Environment(value=EnvType.CLIENT)
    private boolean serverRegistered;

    public FabricC2SChannel(class_2960 id, MessageType<T> type) {
        super(id, type);
        if (EnvironmentUtil.isClient()) {
            this.serverRegistered = false;
        }
    }

    @Override
    public void registerFor(class_3222 player) {
        class_3244 handler = player.field_13987;
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot register packet receiver for " + String.valueOf(this.getId()) + ", player is not in game");
            return;
        }
        ServerPlayNetworking.registerReceiver((class_3244)handler, (class_8710.class_9154)this.id, this::onReceive);
    }

    @Override
    public void unregisterFor(class_3222 player) {
        class_3244 handler = player.field_13987;
        if (handler != null) {
            ServerPlayNetworking.unregisterReceiver((class_3244)handler, (class_2960)this.getId());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void sendToServer(T message) {
        ClientPlayNetworking.send(new Payload<T>(this.id, message));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean canSendToServer() {
        return this.serverRegistered && class_310.method_1551().method_1562() != null;
    }

    @Override
    public void onRegister(MessageContext<T> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = true;
        }
        super.onRegister(context);
    }

    @Override
    public void onUnregister(MessageContext<T> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = false;
        }
        super.onUnregister(context);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onDisconnect() {
        this.serverRegistered = false;
    }

    private void onReceive(Payload<T> payload, ServerPlayNetworking.Context context) {
        this.type.onReceive(payload.value(), new C2SMessageContext(context.player(), this));
    }
}

