/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.joml.Matrix3x2fStack;

public class SelectController<T>
implements Controller<Integer> {
    private final Option<Integer> option;
    private final BiFunction<Integer, T, class_2561> valueFormatter;
    private List<T> values;
    private final List<T> refValues;
    private List<class_2561> formattedValues;

    public SelectController(Option<Integer> option, List<T> values, BiFunction<Integer, T, class_2561> valueFormatter) {
        this.option = option;
        this.valueFormatter = valueFormatter;
        this.refValues = values;
        this.updateValues();
    }

    public void updateValues() {
        this.values = ImmutableList.copyOf(this.refValues);
        this.formattedValues = new ArrayList<class_2561>();
        for (int i = 0; i < this.values.size(); ++i) {
            this.formattedValues.add(this.valueFormatter.apply(i, (Integer)this.values.get(i)));
        }
    }

    public void cycle(int direction) {
        int index = (Integer)this.option.pendingValue();
        if (direction > 0) {
            index = (index + 1) % this.values.size();
        } else if (direction < 0) {
            index = index <= 0 ? this.values.size() - 1 : index - 1;
        }
        this.option.requestSet((Object)index);
    }

    public List<class_2561> formatValues() {
        this.formattedValues.set(this.getSelectedIndex(), this.formatValue());
        return ImmutableList.copyOf(this.formattedValues);
    }

    public int getSelectedIndex() {
        return (Integer)this.option().pendingValue();
    }

    public class_2561 formatValue() {
        int index = (Integer)this.option.pendingValue();
        return this.valueFormatter.apply(index, (Integer)this.values.get(index));
    }

    public Option<Integer> option() {
        return this.option;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new SelectElement(this, screen, widgetDimension);
    }

    public static class SelectElement<T>
    extends ControllerWidget<SelectController<T>> {
        private final int ARROW_SPACE = 8;
        private Dimension<Integer> expandedBounds;
        private Dimension<Integer> arrowBounds;
        private boolean mouseInteracted;
        private long hoveringStart = 0L;
        protected static final class_2561 UP_ARROW = class_2561.method_43470((String)"\u25b2");
        protected static final class_2561 DOWN_ARROW = class_2561.method_43470((String)"\u25bc");

        public SelectElement(SelectController<T> control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
            this.updateValues();
        }

        public void updateValues() {
            this.updateExpandedBounds();
        }

        protected void updateExpandedBounds() {
            Dimension dim = this.getDimension();
            int lines = this.getLineCount();
            int lineHeight = this.getLineHeight();
            int yStart = (Integer)dim.yLimit() - 1;
            int ySpan = lines * lineHeight + 1;
            this.expandedBounds = Dimension.ofInt((int)((Integer)dim.x()), (int)yStart, (int)((Integer)dim.width()), (int)ySpan);
        }

        protected int getLineCount() {
            return Math.min(((SelectController)this.control).formatValues().size(), 5);
        }

        protected int getLineHeight() {
            Objects.requireNonNull(this.textRenderer);
            return 9 + this.getLinePadding();
        }

        protected int getLinePadding() {
            return 2;
        }

        public void setDimension(Dimension<Integer> dim) {
            super.setDimension(dim);
            this.updateExpandedBounds();
            this.updateArrowBounds();
        }

        protected void updateArrowBounds() {
            Dimension dim = this.getDimension();
            this.arrowBounds = Dimension.ofInt((int)((Integer)dim.xLimit() - 8 - 2 * this.getXPadding()), (int)((Integer)dim.y()), (int)(8 + 2 * this.getXPadding()), (int)((Integer)dim.height()));
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            if (this.isHovered() && this.hoveringStart == 0L) {
                this.hoveringStart = class_156.method_659();
            } else if (!this.isHovered()) {
                this.hoveringStart = 0L;
            }
            if (this.mouseInteracted && !this.isHovered()) {
                this.mouseInteracted = false;
            }
            this.drawList(context);
        }

        protected void drawList(class_332 context) {
            if (!this.isMouseInteracted() && !this.method_25370() || !this.isAvailable()) {
                return;
            }
            context.method_51448().pushMatrix();
            List<class_2561> values = ((SelectController)this.control).formatValues();
            Dimension<Integer> dim = this.getExpandedBounds();
            int padding = this.getLinePadding();
            int lines = this.getLineCount();
            int lineHeight = this.getLineHeight();
            int selected = ((SelectController)this.control).getSelectedIndex();
            int indexFrom = class_3532.method_15340((int)(selected - lines / 2), (int)0, (int)(values.size() - lines));
            context.method_25294((Integer)dim.x() + 1, (Integer)dim.y() + 1, (Integer)dim.xLimit() - 1, (Integer)dim.yLimit() - 1, -1342177280);
            this.drawOutline(context, (Integer)dim.x(), (Integer)dim.y(), (Integer)dim.xLimit(), (Integer)dim.yLimit(), 1, -1);
            for (int line = 0; line < lines; ++line) {
                int i = indexFrom + line;
                class_2561 text = values.get(i);
                int x = (Integer)dim.xLimit() - this.textRenderer.method_27525((class_5348)text) - this.getXPadding();
                int y = (Integer)dim.y() + padding + lineHeight * line;
                if (selected == i) {
                    context.method_25294(((Integer)dim.x()).intValue(), y - padding, ((Integer)dim.xLimit()).intValue(), y + lineHeight - 1, -2130706433);
                }
                context.method_27535(this.textRenderer, text, x, y, this.getValueColor());
            }
            context.method_51448().popMatrix();
        }

        public boolean isMouseInteracted() {
            return this.mouseInteracted;
        }

        public void setMouseInteracted(boolean mouseInteracted) {
            this.mouseInteracted = mouseInteracted;
        }

        public Dimension<Integer> getExpandedBounds() {
            return this.expandedBounds;
        }

        protected void drawHoveredControl(class_332 context, int mouseX, int mouseY, float delta) {
            Dimension dim = this.getDimension();
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            int arrowWidth = this.textRenderer.method_27525((class_5348)UP_ARROW);
            matrices.translate((float)((Integer)this.getDimension().xLimit() - this.getXPadding()) - 4.0f, (float)((Integer)dim.y()).intValue() + (float)((Integer)dim.height()).intValue() / 2.0f);
            matrices.scale(1.5f, 1.0f);
            int hoveredArrow = this.getHoveredArrow(mouseX, mouseY);
            int n = -arrowWidth / 2;
            Objects.requireNonNull(this.textRenderer);
            context.method_51439(this.textRenderer, UP_ARROW, n, -9 + 1, -12566464, false);
            context.method_51439(this.textRenderer, DOWN_ARROW, -arrowWidth / 2, 1, -12566464, false);
            int n2 = -arrowWidth / 2;
            Objects.requireNonNull(this.textRenderer);
            context.method_51439(this.textRenderer, UP_ARROW, n2, -9 + 2, hoveredArrow == -1 ? -1 : -4144960, false);
            context.method_51439(this.textRenderer, DOWN_ARROW, -arrowWidth / 2, 0, hoveredArrow == 1 ? -1 : -4144960, false);
            matrices.popMatrix();
        }

        protected int getHoveredArrow(int mouseX, int mouseY) {
            if (!this.arrowBounds.isPointInside((Number)mouseX, (Number)mouseY)) {
                return 0;
            }
            boolean upper = (float)(mouseY - (Integer)this.arrowBounds.y()) / (float)((Integer)this.arrowBounds.height()).intValue() < 0.5f;
            return upper ? -1 : 1;
        }

        protected void drawValueText(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51448().pushMatrix();
            if (this.isHovered()) {
                context.method_51448().translate((float)(-8 - this.getXPadding()), 0.0f);
            }
            super.drawValueText(context, mouseX, mouseY, delta);
            context.method_51448().popMatrix();
        }

        protected class_2561 getValueText() {
            class_2561 valueText = ((SelectController)this.control).formatValue();
            int maxWidth = (Integer)this.getDimension().width() - this.getControlWidth() - this.getXPadding() - 7 - 8;
            String shortened = GuiUtils.shortenString((String)valueText.getString(), (class_327)this.textRenderer, (int)maxWidth, (String)"...");
            return class_2561.method_43470((String)shortened).method_10862(valueText.method_10866());
        }

        protected int getHoveredControlWidth() {
            return this.getUnhoveredControlWidth();
        }

        protected int getUnhoveredControlWidth() {
            return this.textRenderer.method_27525((class_5348)(((SelectController)this.control).option().changed() ? this.modifiedOptionName : ((SelectController)this.control).option().name()));
        }

        public boolean onMouseClicked(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY) || button != 0 && button != 1 || !this.isAvailable()) {
                return false;
            }
            int hoveredArrow = this.getHoveredArrow((int)mouseX, (int)mouseY);
            if (hoveredArrow != 0) {
                this.cycle(hoveredArrow);
                this.setMouseInteracted(true);
                return true;
            }
            this.playDownSound();
            this.setMouseInteracted(!this.isMouseInteracted());
            return true;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            Dimension dim = this.getDimension();
            if (dim == null) {
                return false;
            }
            if (dim.isPointInside((Number)((int)mouseX), (Number)((int)mouseY))) {
                return true;
            }
            Dimension<Integer> expanded = this.getExpandedBounds();
            return this.method_25370() && expanded.isPointInside((Number)((int)mouseX), (Number)((int)mouseY));
        }

        public void cycle(int direction) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)2.0f, (float)0.1f));
            ((SelectController)this.control).cycle(direction);
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (!this.method_25405(mouseX, mouseY) || !this.isAvailable()) {
                return false;
            }
            if (this.hoveringStart == 0L || class_156.method_659() - this.hoveringStart <= 100L) {
                return false;
            }
            if (verticalAmount == 0.0) {
                return false;
            }
            this.cycle(verticalAmount > 0.0 ? -1 : 1);
            this.setMouseInteracted(true);
            return true;
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (!this.focused) {
                return false;
            }
            switch (keyCode) {
                case 263: {
                    this.cycle(-1);
                    break;
                }
                case 262: {
                    this.cycle(1);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.method_25365(true);
            return true;
        }
    }
}

