/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.generation.AdjacentChunkHolder;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IMutableBlockPosWrapper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DhLightingEngine {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final DhLightingEngine INSTANCE = new DhLightingEngine();
    private static final ThreadLocal<DhBlockPosMutable> PRIMARY_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new DhBlockPosMutable());
    private static final ThreadLocal<DhBlockPosMutable> SECONDARY_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new DhBlockPosMutable());
    private static final boolean RENDER_BLOCK_LIGHT_WIREFRAME = false;
    private static final boolean RENDER_SKY_LIGHT_WIREFRAME = false;
    private static final byte[] ADJACENT_DIRECTION_OFFSETS = new byte[]{-1, 0, 1, 0, 0, -1, 0, 1};

    private DhLightingEngine() {
    }

    public void lightChunk(@NotNull IChunkWrapper centerChunk, @NotNull ArrayList<IChunkWrapper> nearbyChunkList, int maxSkyLight) {
        this.lightChunk(centerChunk, nearbyChunkList, maxSkyLight, true, true);
    }

    public void bakeChunkBlockLighting(@NotNull IChunkWrapper centerChunk, @NotNull ArrayList<IChunkWrapper> nearbyChunkList, int maxSkyLight) {
        this.lightChunk(centerChunk, nearbyChunkList, maxSkyLight, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lightChunk(@NotNull IChunkWrapper centerChunk, @NotNull ArrayList<IChunkWrapper> nearbyChunkList, int maxSkyLight, boolean updateBlockLight, boolean updateSkyLight) {
        DhChunkPos centerChunkPos = centerChunk.getChunkPos();
        AdjacentChunkHolder adjacentChunkHolder = new AdjacentChunkHolder(centerChunk);
        StableLightPosStack blockLightWorldPosQueue = null;
        StableLightPosStack skyLightWorldPosQueue = null;
        try {
            blockLightWorldPosQueue = StableLightPosStack.borrowStableLightPosArray();
            skyLightWorldPosQueue = StableLightPosStack.borrowStableLightPosArray();
            HashSet<DhChunkPos> requestedAdjacentPositions = new HashSet<DhChunkPos>(9);
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    DhChunkPos adjacentPos = new DhChunkPos(centerChunkPos.getX() + xOffset, centerChunkPos.getZ() + zOffset);
                    requestedAdjacentPositions.add(adjacentPos);
                }
            }
            for (int chunkIndex = 0; chunkIndex < nearbyChunkList.size(); ++chunkIndex) {
                IChunkWrapper chunk = nearbyChunkList.get(chunkIndex);
                if (chunk != null && requestedAdjacentPositions.contains(chunk.getChunkPos())) {
                    requestedAdjacentPositions.remove(chunk.getChunkPos());
                    adjacentChunkHolder.add(chunk);
                    DhBlockPosMutable relLightBlockPos = PRIMARY_BLOCK_POS_REF.get();
                    if (updateBlockLight) {
                        ArrayList<DhBlockPos> blockLightPosList = chunk.getWorldBlockLightPosList();
                        for (int blockLightIndex = 0; blockLightIndex < blockLightPosList.size(); ++blockLightIndex) {
                            DhBlockPos blockLightPos = blockLightPosList.get(blockLightIndex);
                            blockLightPos.mutateToChunkRelativePos(relLightBlockPos);
                            IBlockStateWrapper blockState = chunk.getBlockState(relLightBlockPos);
                            int lightValue = blockState.getLightEmission();
                            blockLightWorldPosQueue.push(blockLightPos.getX(), blockLightPos.getY(), blockLightPos.getZ(), lightValue);
                            chunk.setDhBlockLight(relLightBlockPos.getX(), relLightBlockPos.getY(), relLightBlockPos.getZ(), lightValue);
                        }
                    }
                    if (updateSkyLight && maxSkyLight > 0) {
                        IMutableBlockPosWrapper mcBlockPos = chunk.getMutableBlockPosWrapper();
                        IBlockStateWrapper previousBlockState = null;
                        int maxY = chunk.getMaxNonEmptyHeight();
                        int minY = chunk.getInclusiveMinBuildHeight();
                        for (int relX = 0; relX < 16; ++relX) {
                            for (int relZ = 0; relZ < 16; ++relZ) {
                                IBlockStateWrapper block;
                                for (int y = maxY; y >= minY && ((block = (previousBlockState = chunk.getBlockState(relX, y, relZ, mcBlockPos, previousBlockState))) == null || block.getOpacity() == 0); --y) {
                                    DhBlockPos skyLightPos = new DhBlockPos(chunk.getMinBlockX() + relX, y, chunk.getMinBlockZ() + relZ);
                                    skyLightWorldPosQueue.push(skyLightPos.getX(), skyLightPos.getY(), skyLightPos.getZ(), maxSkyLight);
                                    skyLightPos.mutateToChunkRelativePos(relLightBlockPos);
                                    chunk.setDhSkyLight(relLightBlockPos.getX(), relLightBlockPos.getY(), relLightBlockPos.getZ(), maxSkyLight);
                                }
                            }
                        }
                    }
                }
                if (requestedAdjacentPositions.isEmpty()) break;
            }
            if (updateBlockLight) {
                centerChunk.clearDhBlockLighting();
                this.propagateChunkLightPosList(blockLightWorldPosQueue, adjacentChunkHolder, (neighbourChunk, relBlockPos) -> neighbourChunk.getDhBlockLight(relBlockPos.getX(), relBlockPos.getY(), relBlockPos.getZ()), (neighbourChunk, relBlockPos, newLightValue) -> neighbourChunk.setDhBlockLight(relBlockPos.getX(), relBlockPos.getY(), relBlockPos.getZ(), newLightValue), true);
            }
            if (updateSkyLight) {
                centerChunk.clearDhSkyLighting();
                this.propagateChunkLightPosList(skyLightWorldPosQueue, adjacentChunkHolder, (neighbourChunk, relBlockPos) -> neighbourChunk.getDhSkyLight(relBlockPos.getX(), relBlockPos.getY(), relBlockPos.getZ()), (neighbourChunk, relBlockPos, newLightValue) -> neighbourChunk.setDhSkyLight(relBlockPos.getX(), relBlockPos.getY(), relBlockPos.getZ(), newLightValue), false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected lighting issue for center chunk: " + centerChunkPos, (Throwable)e);
        }
        finally {
            StableLightPosStack.returnStableLightPosArray(blockLightWorldPosQueue);
            StableLightPosStack.returnStableLightPosArray(skyLightWorldPosQueue);
        }
        if (updateBlockLight) {
            centerChunk.setIsDhBlockLightCorrect(true);
        }
        if (updateSkyLight) {
            centerChunk.setIsDhSkyLightCorrect(true);
        }
    }

    private void propagateChunkLightPosList(StableLightPosStack lightPosQueue, AdjacentChunkHolder adjacentChunkHolder, IGetLightFunc getLightFunc, ISetLightFunc setLightFunc, boolean propagatingBlockLights) {
        LightPos lightPos = new LightPos(0, 0, 0, 0);
        DhBlockPosMutable neighbourBlockPos = PRIMARY_BLOCK_POS_REF.get();
        DhBlockPosMutable relNeighbourBlockPos = SECONDARY_BLOCK_POS_REF.get();
        IMutableBlockPosWrapper mcBlockPos = null;
        IBlockStateWrapper previousBlockState = null;
        while (!lightPosQueue.isEmpty()) {
            lightPosQueue.popMutate(lightPos);
            int lightValue = lightPos.lightValue;
            for (EDhDirection direction : EDhDirection.CARDINAL_DIRECTIONS) {
                IBlockStateWrapper neighbourBlockState;
                int targetLevel;
                int currentBlockLight;
                lightPos.mutateOffset(direction, neighbourBlockPos);
                neighbourBlockPos.mutateToChunkRelativePos(relNeighbourBlockPos);
                IChunkWrapper neighbourChunk = adjacentChunkHolder.getByBlockPos(neighbourBlockPos.getX(), neighbourBlockPos.getZ());
                if (neighbourChunk == null || relNeighbourBlockPos.getY() < neighbourChunk.getMinNonEmptyHeight() || relNeighbourBlockPos.getY() >= neighbourChunk.getExclusiveMaxBuildHeight() || (currentBlockLight = getLightFunc.getLight(neighbourChunk, relNeighbourBlockPos)) >= lightValue - 1) continue;
                if (mcBlockPos == null) {
                    mcBlockPos = neighbourChunk.getMutableBlockPosWrapper();
                }
                if ((targetLevel = lightValue - Math.max(1, (neighbourBlockState = (previousBlockState = neighbourChunk.getBlockState(relNeighbourBlockPos, mcBlockPos, previousBlockState))).getOpacity())) <= currentBlockLight) continue;
                setLightFunc.setLight(neighbourChunk, relNeighbourBlockPos, targetLevel);
                lightPosQueue.push(neighbourBlockPos.getX(), neighbourBlockPos.getY(), neighbourBlockPos.getZ(), targetLevel);
            }
        }
    }

    public void bakeDataSourceSkyLight(FullDataSourceV2 dataSource, int maxSkyLight) {
        long above;
        int index;
        BitSet airIDs = new BitSet(dataSource.mapping.size());
        int size = dataSource.mapping.size();
        for (int id = 0; id < size; ++id) {
            if (dataSource.mapping.getBlockStateWrapper(id).getOpacity() != 0) continue;
            airIDs.set(id, true);
        }
        for (int z = 0; z < 64; ++z) {
            for (int x = 0; x < 64; ++x) {
                LongArrayList dataPoints = dataSource.get(x, z);
                if (dataPoints == null || dataPoints.isEmpty()) continue;
                int size2 = dataPoints.size();
                for (index = 0; index < size2; ++index) {
                    int skylight;
                    long point = dataPoints.getLong(index);
                    if (!airIDs.get(FullDataPointUtil.getId(point))) continue;
                    if (index == 0) {
                        skylight = maxSkyLight;
                    } else {
                        above = dataPoints.getLong(index - 1);
                        if (!airIDs.get(FullDataPointUtil.getId(above))) continue;
                        skylight = FullDataPointUtil.getSkyLight(above);
                    }
                    point = FullDataPointUtil.setSkyLight(point, skylight);
                    dataPoints.set(index, point);
                    this.recursivelyLightAdjacentDataPoints(dataSource, airIDs, x, z, point);
                }
            }
        }
        for (LongArrayList list : dataSource.dataPoints) {
            if (list == null) continue;
            int size3 = list.size();
            for (index = 0; index < size3; ++index) {
                long dataPoint = list.getLong(index);
                if (index == 0) {
                    dataPoint = FullDataPointUtil.setSkyLight(dataPoint, maxSkyLight);
                    list.set(index, dataPoint);
                    continue;
                }
                if (airIDs.get(FullDataPointUtil.getId(dataPoint))) continue;
                above = list.getLong(index - 1);
                int aboveLight = FullDataPointUtil.getSkyLight(above);
                if (airIDs.get(FullDataPointUtil.getId(above))) {
                    dataPoint = FullDataPointUtil.setSkyLight(dataPoint, aboveLight);
                    list.set(index, dataPoint);
                    continue;
                }
                int absorption = dataSource.mapping.getBlockStateWrapper(FullDataPointUtil.getId(above)).getOpacity() * FullDataPointUtil.getHeight(above);
                if (absorption >= aboveLight) continue;
                dataPoint = FullDataPointUtil.setSkyLight(dataPoint, aboveLight - absorption);
                list.set(index, dataPoint);
            }
        }
    }

    public void recursivelyLightAdjacentDataPoints(FullDataSourceV2 chunk, BitSet airIDs, int relativeX, int relativeZ, long dataPoint) {
        int lightLevel = FullDataPointUtil.getSkyLight(dataPoint);
        if (lightLevel <= 1) {
            return;
        }
        int minY = FullDataPointUtil.getBottomY(dataPoint);
        int maxY = FullDataPointUtil.getHeight(dataPoint) + minY;
        int offsetIndex = 0;
        block0: while (offsetIndex < ADJACENT_DIRECTION_OFFSETS.length) {
            LongArrayList adjacentDataPoints;
            int adjacentX = relativeX + ADJACENT_DIRECTION_OFFSETS[offsetIndex++];
            int adjacentZ = relativeZ + ADJACENT_DIRECTION_OFFSETS[offsetIndex++];
            if (adjacentX < 0 || adjacentX >= 64 || adjacentZ < 0 || adjacentZ >= 64 || (adjacentDataPoints = chunk.get(adjacentX, adjacentZ)) == null) continue;
            int size = adjacentDataPoints.size();
            for (int adjacentIndex = 0; adjacentIndex < size; ++adjacentIndex) {
                int adjacentLightLevel;
                long adjacentDataPoint = adjacentDataPoints.getLong(adjacentIndex);
                int adjacentMinY = FullDataPointUtil.getBottomY(adjacentDataPoint);
                int adjacentMaxY = FullDataPointUtil.getHeight(adjacentDataPoint) + adjacentMinY;
                if (adjacentMinY >= maxY) continue;
                if (adjacentMaxY <= minY) continue block0;
                if (!airIDs.get(FullDataPointUtil.getId(adjacentDataPoint)) || lightLevel - 1 <= (adjacentLightLevel = FullDataPointUtil.getSkyLight(adjacentDataPoint))) continue;
                adjacentDataPoint = FullDataPointUtil.setSkyLight(adjacentDataPoint, lightLevel - 1);
                adjacentDataPoints.set(adjacentIndex, adjacentDataPoint);
                this.recursivelyLightAdjacentDataPoints(chunk, airIDs, adjacentX, adjacentZ, adjacentDataPoint);
            }
        }
    }

    private static void RenderDhLightValuesAsWireframe(AdjacentChunkHolder adjacentChunkHolder, boolean renderBlockLights) {
        for (IChunkWrapper chunk : adjacentChunkHolder.chunkArray) {
            if (chunk == null) continue;
            int chunkMinX = chunk.getMinBlockX();
            int chunkMinZ = chunk.getMinBlockZ();
            int minY = chunk.getMinNonEmptyHeight();
            int maxY = chunk.getMaxNonEmptyHeight();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        Color color;
                        int lightValue;
                        int n = lightValue = renderBlockLights ? chunk.getDhBlockLight(x, y, z) : chunk.getDhSkyLight(x, y, z);
                        if (lightValue == 0 || (color = lightValue >= 14 ? Color.WHITE : (lightValue >= 10 ? Color.PINK : (lightValue >= 6 ? Color.YELLOW : (lightValue >= 4 ? Color.ORANGE : Color.RED)))) == null) continue;
                        DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(DhSectionPos.encode((byte)0, chunkMinX + x, chunkMinZ + z), (float)y, (float)(y + 1), 0.2f, color), 10.0, 0.0f));
                    }
                }
            }
        }
    }

    private static class StableLightPosStack {
        private static final ReentrantLock cacheLock = new ReentrantLock();
        private static final Queue<StableLightPosStack> lightArrayCache = new ArrayDeque<StableLightPosStack>();
        private int index = -1;
        public static final int INTS_PER_LIGHT_POS = 4;
        private final IntArrayList lightPositions = new IntArrayList(160000);

        private StableLightPosStack() {
        }

        private static StableLightPosStack borrowStableLightPosArray() {
            try {
                cacheLock.lock();
                StableLightPosStack stableLightPosStack = lightArrayCache.isEmpty() ? new StableLightPosStack() : lightArrayCache.remove();
                return stableLightPosStack;
            }
            finally {
                cacheLock.unlock();
            }
        }

        private static void returnStableLightPosArray(StableLightPosStack stableArray) {
            try {
                cacheLock.lock();
                if (stableArray != null) {
                    lightArrayCache.add(stableArray);
                }
            }
            finally {
                cacheLock.unlock();
            }
        }

        public boolean isEmpty() {
            return this.index == -1;
        }

        public int size() {
            return this.index + 1;
        }

        public void push(int blockX, int blockY, int blockZ, int lightValue) {
            ++this.index;
            int subIndex = this.index * 4;
            if (subIndex < this.lightPositions.size()) {
                this.lightPositions.set(subIndex, blockX);
                this.lightPositions.set(subIndex + 1, blockY);
                this.lightPositions.set(subIndex + 2, blockZ);
                this.lightPositions.set(subIndex + 3, lightValue);
            } else {
                this.lightPositions.add(blockX);
                this.lightPositions.add(blockY);
                this.lightPositions.add(blockZ);
                this.lightPositions.add(lightValue);
            }
        }

        public void popMutate(LightPos pos) {
            int subIndex = this.index * 4;
            pos.setX(this.lightPositions.getInt(subIndex));
            pos.setY(this.lightPositions.getInt(subIndex + 1));
            pos.setZ(this.lightPositions.getInt(subIndex + 2));
            pos.lightValue = this.lightPositions.getInt(subIndex + 3);
            --this.index;
        }

        public String toString() {
            return this.index + "/" + this.lightPositions.size() / 4;
        }
    }

    @FunctionalInterface
    static interface IGetLightFunc {
        public int getLight(IChunkWrapper var1, DhBlockPos var2);
    }

    @FunctionalInterface
    static interface ISetLightFunc {
        public void setLight(IChunkWrapper var1, DhBlockPos var2, int var3);
    }

    private static class LightPos
    extends DhBlockPosMutable {
        public int lightValue;

        public LightPos(int x, int y, int z, int lightValue) {
            super(x, y, z);
            this.lightValue = lightValue;
        }

        @Override
        public String toString() {
            return this.lightValue + " - [" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }
}

