/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.lz.LZDecoder;
import org.tukaani.xz.lzma.LZMADecoder;
import org.tukaani.xz.rangecoder.RangeDecoderFromStream;

public class LZMAInputStream
extends InputStream {
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    private InputStream in;
    private ArrayCache arrayCache;
    private LZDecoder lz;
    private RangeDecoderFromStream rc;
    private LZMADecoder lzma;
    private boolean endReached = false;
    private boolean relaxedEndCondition = false;
    private final byte[] tempBuf = new byte[1];
    private long remainingSize;
    private IOException exception = null;

    public static int getMemoryUsage(int i, byte b) throws UnsupportedOptionsException, CorruptedInputException {
        if (i < 0 || i > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        int n = b & 0xFF;
        if (n > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n2 = (n %= 45) / 9;
        int n3 = n - n2 * 9;
        return LZMAInputStream.getMemoryUsage(i, n3, n2);
    }

    public static int getMemoryUsage(int i, int j, int k) {
        if (j < 0 || j > 8 || k < 0 || k > 4) {
            throw new IllegalArgumentException("Invalid lc or lp");
        }
        return 10 + LZMAInputStream.getDictSize(i) / 1024 + (1536 << j + k) / 1024;
    }

    private static int getDictSize(int i) {
        if (i < 0 || i > 0x7FFFFFF0) {
            throw new IllegalArgumentException("LZMA dictionary is too big for this implementation");
        }
        if (i < 4096) {
            i = 4096;
        }
        return i + 15 & 0xFFFFFFF0;
    }

    public LZMAInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public LZMAInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, int i) throws IOException {
        this(inputStream, i, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, int i, ArrayCache arrayCache) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        int n2 = 0;
        for (int j = 0; j < 4; ++j) {
            n2 |= dataInputStream.readUnsignedByte() << 8 * j;
        }
        long l = 0L;
        for (n = 0; n < 8; ++n) {
            l |= (long)dataInputStream.readUnsignedByte() << 8 * n;
        }
        n = LZMAInputStream.getMemoryUsage(n2, by);
        if (i != -1 && n > i) {
            throw new MemoryLimitException(n, i);
        }
        this.initialize(inputStream, l, by, n2, null, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l, byte b, int i) throws IOException {
        this.initialize(inputStream, l, b, i, null, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, byte b, int i, byte[] bs) throws IOException {
        this.initialize(inputStream, l, b, i, bs, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, byte b, int i, byte[] bs, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l, b, i, bs, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l, int i, int j, int k, int m, byte[] bs) throws IOException {
        this.initialize(inputStream, l, i, j, k, m, bs, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l, int i, int j, int k, int m, byte[] bs, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l, i, j, k, m, bs, arrayCache);
    }

    private void initialize(InputStream inputStream, long l, byte b, int i, byte[] bs, ArrayCache arrayCache) throws IOException {
        if (l < -1L) {
            throw new UnsupportedOptionsException("Uncompressed size is too big");
        }
        int n = b & 0xFF;
        if (n > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n2 = n / 45;
        int n3 = (n -= n2 * 9 * 5) / 9;
        int n4 = n - n3 * 9;
        if (i < 0 || i > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        this.initialize(inputStream, l, n4, n3, n2, i, bs, arrayCache);
    }

    private void initialize(InputStream inputStream, long l, int i, int j, int k, int m, byte[] bs, ArrayCache arrayCache) throws IOException {
        if (l < -1L || i < 0 || i > 8 || j < 0 || j > 4 || k < 0 || k > 4) {
            throw new IllegalArgumentException();
        }
        this.in = inputStream;
        this.arrayCache = arrayCache;
        m = LZMAInputStream.getDictSize(m);
        if (l >= 0L && (long)m > l) {
            m = LZMAInputStream.getDictSize((int)l);
        }
        this.lz = new LZDecoder(LZMAInputStream.getDictSize(m), bs, arrayCache);
        this.rc = new RangeDecoderFromStream(inputStream);
        this.lzma = new LZMADecoder(this.lz, this.rc, i, j, k);
        this.remainingSize = l;
    }

    public void enableRelaxedEndCondition() {
        this.relaxedEndCondition = true;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] bs, int i, int j) throws IOException {
        if (i < 0 || j < 0 || i + j < 0 || i + j > bs.length) {
            throw new IndexOutOfBoundsException();
        }
        if (j == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int n = 0;
            while (j > 0) {
                int n2 = j;
                if (this.remainingSize >= 0L && this.remainingSize < (long)j) {
                    n2 = (int)this.remainingSize;
                }
                this.lz.setLimit(n2);
                try {
                    this.lzma.decode();
                }
                catch (CorruptedInputException corruptedInputException) {
                    if (this.remainingSize != -1L || !this.lzma.endMarkerDetected()) {
                        throw corruptedInputException;
                    }
                    this.endReached = true;
                    this.rc.normalize();
                }
                int n3 = this.lz.flush(bs, i);
                i += n3;
                j -= n3;
                n += n3;
                if (this.remainingSize >= 0L) {
                    this.remainingSize -= (long)n3;
                    assert (this.remainingSize >= 0L);
                    if (this.remainingSize == 0L) {
                        this.endReached = true;
                    }
                }
                if (!this.endReached) continue;
                if (this.lz.hasPending() || !this.relaxedEndCondition && !this.rc.isFinished()) {
                    throw new CorruptedInputException();
                }
                this.putArraysToCache();
                return n == 0 ? -1 : n;
            }
            return n;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void putArraysToCache() {
        if (this.lz != null) {
            this.lz.putArraysToCache(this.arrayCache);
            this.lz = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.putArraysToCache();
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

