/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui;

import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiControlRect {
    protected final GuiClientControl control;
    private int left;
    private int top;
    private int right;
    private int bottom;

    public static int getMinWidth(GuiClientControl control, int availableWidth) {
        int minWidth;
        if (control.preferred != null && (minWidth = control.preferred.minWidth(control, availableWidth)) != -1) {
            return minWidth;
        }
        return control.minWidth(availableWidth);
    }

    public static int getPreferredWidth(GuiClientControl control, int availableWidth) {
        int prefWidth;
        if (control.preferred != null && (prefWidth = control.preferred.preferredWidth(control, availableWidth)) != -1) {
            return prefWidth;
        }
        return control.preferredWidth(availableWidth);
    }

    public static int getMaxWidth(GuiClientControl control, int availableWidth) {
        int maxWidth;
        if (control.preferred != null && (maxWidth = control.preferred.maxWidth(control, availableWidth)) != -1) {
            return maxWidth;
        }
        return control.maxWidth(availableWidth);
    }

    public static int getMinHeight(GuiClientControl control, int width, int availableHeight) {
        int minHeight;
        if (control.preferred != null && (minHeight = control.preferred.minHeight(control, width, availableHeight)) != -1) {
            return minHeight;
        }
        return control.minHeight(width, availableHeight);
    }

    public static int getPreferredHeight(GuiClientControl control, int width, int availableHeight) {
        int prefHeight;
        if (control.preferred != null && (prefHeight = control.preferred.preferredHeight(control, width, availableHeight)) != -1) {
            return prefHeight;
        }
        return control.preferredHeight(width, availableHeight);
    }

    public static int getMaxHeight(GuiClientControl control, int width, int availableHeight) {
        int maxHeight;
        if (control.preferred != null && (maxHeight = control.preferred.maxHeight(control, width, availableHeight)) != -1) {
            return maxHeight;
        }
        return control.maxHeight(width, availableHeight);
    }

    public GuiControlRect(GuiClientControl control) {
        this.control = control;
    }

    public int getX() {
        return this.left;
    }

    public void setX(int x) {
        int width = this.getWidth();
        this.left = x;
        this.right = x + width;
    }

    public int getY() {
        return this.top;
    }

    public void setY(int y) {
        int height = this.getHeight();
        this.top = y;
        this.bottom = y + height;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int x) {
        this.right = x;
    }

    public void setBottom(int y) {
        this.bottom = y;
    }

    public int getContentWidth() {
        return this.getWidth() - this.control.getContentOffset() * 2;
    }

    public int getContentHeight() {
        return this.getHeight() - this.control.getContentOffset() * 2;
    }

    protected int clampWidth(int width, int availableWidth) {
        int max;
        int min = this.getMinWidth(availableWidth);
        if (min != -1) {
            width = Math.max(width, min);
        }
        if ((max = this.getMaxWidth(availableWidth)) != -1) {
            width = Math.min(width, max);
        }
        return width;
    }

    public int setWidth(int width, int availableWidth) {
        width = this.clampWidth(width, availableWidth);
        this.right = this.left + width;
        return width;
    }

    protected int clampHeight(int height, int availableHeight) {
        int max;
        int min = this.getMinHeight(availableHeight);
        if (min != -1) {
            height = Math.max(height, min);
        }
        if ((max = this.getMaxHeight(availableHeight)) != -1) {
            height = Math.min(height, max);
        }
        return height;
    }

    public int setHeight(int height, int availableHeight) {
        height = this.clampHeight(height, availableHeight);
        this.bottom = this.top + height;
        return height;
    }

    public int addWidth(int additional, int availableWidth) {
        int before = this.getWidth();
        this.setWidth(this.getWidth() + additional, availableWidth);
        return this.getWidth() - before;
    }

    public int addHeight(int additional, int availableHeight) {
        int before = this.getHeight();
        this.setHeight(this.getHeight() + additional, availableHeight);
        return this.getHeight() - before;
    }

    public boolean isMaxWidth(int availableWidth) {
        if (this.getMaxWidth(availableWidth) != -1) {
            return this.getWidth() >= this.getMaxWidth(availableWidth);
        }
        return false;
    }

    public boolean isMaxHeight(int availableHeight) {
        if (this.getMaxHeight(availableHeight) != -1) {
            return this.getHeight() >= this.getMaxHeight(availableHeight);
        }
        return false;
    }

    public int getMinWidth(int availableWidth) {
        int min = GuiControlRect.getMinWidth(this.control, availableWidth);
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxWidth(int availableWidth) {
        int max = GuiControlRect.getMaxWidth(this.control, availableWidth);
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredWidth(int availableWidth) {
        return this.clampWidth(GuiControlRect.getPreferredWidth(this.control, availableWidth) + this.control.getContentOffset() * 2, availableWidth);
    }

    public int getMinHeight(int availableHeight) {
        int min = GuiControlRect.getMinHeight(this.control, this.getContentWidth(), availableHeight);
        if (min != -1) {
            return min + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getMaxHeight(int availableHeight) {
        int max = GuiControlRect.getMaxHeight(this.control, this.getContentWidth(), availableHeight);
        if (max != -1) {
            return max + this.control.getContentOffset() * 2;
        }
        return -1;
    }

    public int getPreferredHeight(int availableHeight) {
        return this.clampHeight(GuiControlRect.getPreferredHeight(this.control, this.getContentWidth(), availableHeight) + this.control.getContentOffset() * 2, availableHeight);
    }

    public void flowX() {
        int width = this.getContentWidth();
        this.control.flowX(width, this.control.preferredWidth(width));
    }

    public void flowY() {
        int width = this.getContentWidth();
        int height = this.getContentHeight();
        this.control.flowY(width, height, this.control.preferredHeight(width, height));
    }

    public boolean inside(double x, double y) {
        return x >= (double)this.left && x < (double)this.right && y >= (double)this.top && y < (double)this.bottom;
    }

    public boolean insideLocalPos(double x, double y) {
        return x >= 0.0 && x < (double)this.getWidth() && y >= 0.0 && y < (double)this.getHeight();
    }

    public boolean isExpandableX() {
        return this.control.isExpandableX();
    }

    public boolean isExpandableY() {
        return this.control.isExpandableY();
    }

    public Rect rectCopy() {
        return new Rect(this.left, this.top, this.right, this.bottom);
    }

    public String toString() {
        return "[" + this.left + "," + this.top + "," + this.right + "," + this.bottom + "]";
    }
}

