/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.integration.ScreenEventListener;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.util.math.geo.Rect;

public interface IGuiClientIntegratedParent
extends IGuiIntegratedParent {
    public static void render(IGuiIntegratedParent parent, class_332 graphics, class_437 screen, ScreenEventListener listener, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.method_51448();
        int width = screen.field_22789;
        int height = screen.field_22790;
        listener.tick();
        Rect screenRect = GuiClientControl.getScreenRect();
        List<GuiLayer> layers = parent.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            GuiLayer layer = layers.get(i);
            GuiClientLayer cLayer = (GuiClientLayer)layer.dist();
            if (i == layers.size() - 1) {
                if (cLayer.hasGrayBackground()) {
                    ((CreativeGuiGraphics)graphics).verticalGradientRect(0, 0, width, height, -1072689136, -804253680);
                }
                CreativeCoreClient.postBackgroundEvent(screen, graphics, mouseX, mouseY);
            }
            pose.pushMatrix();
            int offX = (width - cLayer.getWidth()) / 2;
            int offY = (height - cLayer.getHeight()) / 2;
            pose.translate((float)offX, (float)offY);
            Rect controlRect = new Rect(offX, offY, offX + cLayer.getWidth(), offY + cLayer.getHeight());
            cLayer.render(graphics, controlRect, screenRect.intersection(controlRect), 1.0, mouseX, mouseY);
            pose.popMatrix();
            GuiClientControl.scissor(graphics, null);
        }
        ((CreativeGuiGraphics)graphics).clearOverrideScissor();
        if (layers.isEmpty()) {
            return;
        }
        GuiLayer layer = parent.getTopLayer();
        GuiClientLayer cLayer = (GuiClientLayer)layer.dist();
        GuiTooltipEvent event = cLayer.getTooltipEvent(mouseX - listener.getOffsetX(), mouseY - listener.getOffsetY());
        if (event != null) {
            layer.raiseEvent(event);
            if (!event.isCanceled()) {
                class_327 font = class_310.method_1551().field_1772;
                List<class_5684> list = CreativeCoreClient.gatherTooltipComponents(class_1799.field_8037, event.tooltip, Optional.empty(), mouseX, graphics.method_51421(), graphics.method_51443(), font);
                graphics.method_51435(font, list, mouseX, mouseY, class_8001.field_41687, null);
            }
        }
    }

    @Override
    default public Rect toScreenRect(GuiControl control, Rect rect) {
        if (control instanceof GuiLayer) {
            GuiLayer layer = (GuiLayer)control;
            GuiClientLayer cLayer = (GuiClientLayer)layer.dist();
            int offX = (class_310.method_1551().method_22683().method_4486() - cLayer.getWidth()) / 2;
            int offY = (class_310.method_1551().method_22683().method_4502() - cLayer.getHeight()) / 2;
            rect.move(offX, offY);
        }
        return rect;
    }
}

