/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event;

import dev.architectury.event.fabric.EventHandlerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;

public final class EventHandler {
    private static boolean initialized = false;

    private EventHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (Platform.getEnvironment() == Env.CLIENT) {
            EventHandler.registerClient();
        }
        EventHandler.registerCommon();
        if (Platform.getEnvironment() == Env.SERVER) {
            EventHandler.registerServer();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerClient() {
        EventHandlerImpl.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerCommon() {
        EventHandlerImpl.registerCommon();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerServer() {
        EventHandlerImpl.registerServer();
    }
}

