/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.sound;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import team.creative.ambientsounds.condition.AmbientCondition;
import team.creative.ambientsounds.condition.AmbientSelection;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.ambientsounds.engine.AmbientStackType;
import team.creative.ambientsounds.environment.AmbientEnvironment;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientSoundCategory
extends AmbientCondition {
    public String parent;
    public AmbientStackType stack = AmbientStackType.overwrite;
    public transient String name;
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public transient AmbientSoundCategory parentCategory;
    public transient List<AmbientSoundCategory> children = new ArrayList<AmbientSoundCategory>();
    public transient AmbientSelection selection;

    @Override
    public void init(AmbientEngine engine) throws AmbientEngineLoadException {
        super.init(engine);
        this.parentCategory = engine.getSoundCategory(this.parent);
        if (this.parentCategory != null) {
            this.parentCategory.children.add(this);
        }
        if (this.parentCategory == this) {
            throw new AmbientEngineLoadException("Sound cateogry cannot have itself as a parent " + this.name);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void postInit(HashSet<String> remaining) {
        remaining.remove(this.name);
        for (AmbientSoundCategory cat : this.children) {
            cat.postInit(remaining);
        }
    }

    public void tick(AmbientEnvironment env, AmbientSelection parentSelection) {
        this.selection = this.value(env);
        if (this.selection != null) {
            if (parentSelection != null) {
                this.selection.last().subSelection = parentSelection;
            }
            this.selection.mulSetting(this.volumeSetting);
        }
        for (AmbientSoundCategory child : this.children) {
            child.tick(env, this.selection);
        }
    }

    public void collectDetails(DebugTextRenderer text) {
        if (this.selection == null) {
            return;
        }
        text.detail(this.name, (Object)this.selection.volume());
        for (AmbientSoundCategory child : this.children) {
            child.collectDetails(text);
        }
    }
}

