/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.impl.AnimatedDynamicTextureImage;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageRendererManager {
    private static final ExecutorService SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(task -> new Thread(task, "YACL Image Prep"));
    private static final Map<class_2960, CompletableFuture<ImageRenderer>> IMAGE_CACHE = new ConcurrentHashMap<class_2960, CompletableFuture<ImageRenderer>>();
    static final Map<class_2960, ImageRenderer> PRELOADED_IMAGE_CACHE = new ConcurrentHashMap<class_2960, ImageRenderer>();
    static final List<PreloadedImageFactory> PRELOADED_IMAGE_FACTORIES = Stream.of(YACLConfig.HANDLER.instance().preloadComplexImageFormats ? new PreloadedImageFactory(location -> location.method_12832().endsWith(".webp"), AnimatedDynamicTextureImage::createWEBPFromTexture) : null, YACLConfig.HANDLER.instance().preloadComplexImageFormats ? new PreloadedImageFactory(location -> location.method_12832().endsWith(".gif"), AnimatedDynamicTextureImage::createGIFFromTexture) : null).filter(Objects::nonNull).toList();

    public static <T extends ImageRenderer> Optional<T> getImage(class_2960 id) {
        if (PRELOADED_IMAGE_CACHE.containsKey(id)) {
            return Optional.of(PRELOADED_IMAGE_CACHE.get(id));
        }
        if (IMAGE_CACHE.containsKey(id)) {
            return Optional.ofNullable(IMAGE_CACHE.get(id).getNow(null));
        }
        return Optional.empty();
    }

    public static <T extends ImageRenderer> CompletableFuture<T> registerOrGetImage(class_2960 id, Supplier<ImageRendererFactory> factorySupplier) {
        if (PRELOADED_IMAGE_CACHE.containsKey(id)) {
            return CompletableFuture.completedFuture(PRELOADED_IMAGE_CACHE.get(id));
        }
        if (IMAGE_CACHE.containsKey(id)) {
            return IMAGE_CACHE.get(id);
        }
        CompletableFuture future = new CompletableFuture();
        IMAGE_CACHE.put(id, future);
        ImageRendererFactory factory = factorySupplier.get();
        SINGLE_THREAD_EXECUTOR.submit(() -> {
            Supplier<Optional<ImageRendererFactory.ImageSupplier>> supplier = factory.requiresOffThreadPreparation() ? new CompletedSupplier<Optional<ImageRendererFactory.ImageSupplier>>(ImageRendererManager.safelyPrepareFactory(id, factory)) : () -> ImageRendererManager.safelyPrepareFactory(id, factory);
            class_310.method_1551().execute(() -> ImageRendererManager.completeImageFactory(id, supplier, future));
        });
        return future;
    }

    @Deprecated
    public static <T extends ImageRenderer> CompletableFuture<T> registerImage(class_2960 id, ImageRendererFactory factory) {
        return ImageRendererManager.registerOrGetImage(id, () -> factory);
    }

    private static <T extends ImageRenderer> void completeImageFactory(class_2960 id, Supplier<Optional<ImageRendererFactory.ImageSupplier>> supplier, CompletableFuture<ImageRenderer> future) {
        ImageRenderer image;
        RenderSystem.assertOnRenderThread();
        ImageRendererFactory.ImageSupplier completableImage = supplier.get().orElse(null);
        if (completableImage == null) {
            return;
        }
        if (future.isDone()) {
            YACLConstants.LOGGER.error("Image '{}' was already completed", (Object)id);
            return;
        }
        try {
            image = completableImage.completeImage();
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)id, (Object)e);
            return;
        }
        future.complete(image);
    }

    public static void closeAll() {
        SINGLE_THREAD_EXECUTOR.shutdownNow();
        IMAGE_CACHE.values().removeIf(future -> {
            if (future.isDone()) {
                ((ImageRenderer)future.join()).close();
            }
            return true;
        });
    }

    static Optional<ImageRendererFactory.ImageSupplier> safelyPrepareFactory(class_2960 id, ImageRendererFactory factory) {
        try {
            return Optional.of(factory.prepareImage());
        }
        catch (Exception e) {
            YACLConstants.LOGGER.error("Failed to prepare image '{}'", (Object)id, (Object)e);
            IMAGE_CACHE.remove(id);
            return Optional.empty();
        }
    }

    private record CompletedSupplier<T>(T get) implements Supplier<T>
    {
    }

    public record PreloadedImageFactory(Predicate<class_2960> predicate, Function<class_2960, ImageRendererFactory> factory) {
    }
}

