/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.platform;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import malte0811.ferritecore.mixin.config.IPlatformConfigHooks;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;

public class ConfigFileHandler
implements IPlatformConfigHooks {
    @Override
    public void readAndUpdateConfig(List<FerriteConfig.Option> options) throws IOException {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path config = configDir.resolve("ferritecore.mixin.properties");
        if (!Files.exists(config, new LinkOption[0])) {
            block6: {
                try {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException x) {
                    if (Files.isDirectory(configDir, new LinkOption[0])) break block6;
                    throw new IOException("Config dir exists, but is not a directory?", x);
                }
            }
            Files.createFile(config, new FileAttribute[0]);
        }
        Properties propsInFile = new Properties();
        propsInFile.load(Files.newInputStream(config, new OpenOption[0]));
        Object2BooleanOpenHashMap existingOptions = new Object2BooleanOpenHashMap();
        for (String key : propsInFile.stringPropertyNames()) {
            existingOptions.put((Object)key, Boolean.parseBoolean(propsInFile.getProperty(key)));
        }
        ArrayList<CallSite> newLines = new ArrayList<CallSite>();
        Object2BooleanOpenHashMap actualOptions = new Object2BooleanOpenHashMap();
        for (FerriteConfig.Option o : options) {
            boolean value = existingOptions.getOrDefault((Object)o.getName(), o.getDefaultValue());
            actualOptions.put((Object)o.getName(), value);
            newLines.add((CallSite)((Object)("# " + o.getComment())));
            newLines.add((CallSite)((Object)(o.getName() + " = " + value)));
        }
        for (FerriteConfig.Option o : options) {
            o.set(arg_0 -> ((Object2BooleanMap)actualOptions).getBoolean(arg_0));
        }
        Files.write(config, newLines, new OpenOption[0]);
    }

    @Override
    public void collectDisabledOverrides(IPlatformConfigHooks.OverrideCallback disableOption) {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue customValue = (CustomValue)mod.getMetadata().getCustomValues().get("ferritecore:disabled_options");
            if (customValue == null) continue;
            String modId = mod.getMetadata().getId();
            for (CustomValue disabledOptionValue : customValue.getAsArray()) {
                disableOption.addOverride(disabledOptionValue.getAsString(), modId);
            }
        }
    }
}

