/*
 * Decompiled with CFR 0.152.
 */
package net.puzzlemc.splashscreen;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import eu.midnightdust.lib.util.MidnightColorUtil;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_425;
import net.minecraft.class_4668;
import net.minecraft.class_9851;
import net.puzzlemc.core.PuzzleCore;
import net.puzzlemc.core.config.PuzzleConfig;
import net.puzzlemc.splashscreen.mixin.RenderPipelinesAccessor;

public class PuzzleSplashScreen {
    public static final class_2960 LOGO = class_2960.method_60654((String)"textures/gui/title/mojangstudios.png");
    public static final class_2960 BACKGROUND = class_2960.method_60654((String)"puzzle/splash_background.png");
    public static File CONFIG_PATH = new File(String.valueOf(PlatformFunctions.getConfigDirectory().resolve(".puzzle_cache")));
    public static Path LOGO_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/mojangstudios.png", new String[0]);
    public static Path BACKGROUND_TEXTURE = Paths.get(String.valueOf(CONFIG_PATH) + "/splash_background.png", new String[0]);
    private static class_310 client = class_310.method_1551();
    private static boolean keepBackground = false;
    private static class_1921 CUSTOM_LOGO_LAYER;

    public static void init() {
        if (!CONFIG_PATH.exists() && CONFIG_PATH.mkdir() && class_156.method_668().equals((Object)class_156.class_158.field_1133)) {
            try {
                Files.setAttribute(CONFIG_PATH.toPath(), "dos:hidden", true, new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        PuzzleSplashScreen.buildRenderLayer();
    }

    public static class_1921 getCustomLogoRenderLayer() {
        return CUSTOM_LOGO_LAYER;
    }

    public static void buildRenderLayer() {
        if (PuzzleConfig.resourcepackSplashScreen) {
            BlendFunction blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE);
            if (PuzzleConfig.disableBlend) {
                blendFunction = null;
            } else if (PuzzleConfig.customBlendFunction.size() == 4) {
                try {
                    blendFunction = new BlendFunction(SourceFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(0)), DestFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(1)), SourceFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(2)), DestFactor.valueOf((String)PuzzleConfig.customBlendFunction.get(3)));
                }
                catch (Exception e) {
                    PuzzleCore.LOGGER.error("Incorrect blend function defined in color.properties: {}{}", PuzzleConfig.customBlendFunction, (Object)e.getMessage());
                }
            }
            RenderPipeline.Builder CUSTOM_LOGO_PIPELINE_BUILDER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.getPOSITION_TEX_COLOR_SNIPPET()}).withLocation("pipeline/mojang_logo_puzzle").withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false);
            CUSTOM_LOGO_PIPELINE_BUILDER = blendFunction != null ? CUSTOM_LOGO_PIPELINE_BUILDER.withBlend(blendFunction) : CUSTOM_LOGO_PIPELINE_BUILDER.withoutBlend();
            CUSTOM_LOGO_LAYER = class_1921.method_24048((String)"mojang_logo_puzzle", (int)786432, (RenderPipeline)CUSTOM_LOGO_PIPELINE_BUILDER.build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(class_425.field_2483, class_9851.field_52396, false)).method_23617(false));
        }
    }

    public static void resetColors() {
        PuzzleConfig.backgroundColor = 15675965;
        PuzzleConfig.progressBarColor = 0xFFFFFF;
        PuzzleConfig.progressBarBackgroundColor = 15675965;
        PuzzleConfig.progressFrameColor = 0xFFFFFF;
        PuzzleConfig.disableBlend = false;
        PuzzleConfig.customBlendFunction = new ArrayList<String>();
        PuzzleConfig.hasCustomSplashScreen = false;
    }

    public static class DynamicLogoTexture
    extends class_1049 {
        public DynamicLogoTexture() {
            super(LOGO);
        }

        public class_10539 method_65809(class_3300 resourceManager) {
            try {
                FileInputStream input = new FileInputStream(String.valueOf(LOGO_TEXTURE));
                return new class_10539(class_1011.method_4309((InputStream)input), new class_1084(true, true));
            }
            catch (IOException e) {
                PuzzleCore.LOGGER.error("Encountered an error during logo loading: ", (Throwable)e);
                try {
                    return class_10539.method_65871((class_3300)resourceManager, (class_2960)LOGO);
                }
                catch (IOException ex) {
                    return class_10539.method_65870();
                }
            }
        }
    }

    public static class LogoTexture
    extends class_1049 {
        public LogoTexture(class_2960 logo) {
            super(logo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public class_10539 method_65809(class_3300 resourceManager) {
            class_310 minecraftClient = class_310.method_1551();
            class_3268 defaultResourcePack = minecraftClient.method_45573();
            try {
                class_10539 var6;
                try (InputStream inputStream = (InputStream)Objects.requireNonNull(defaultResourcePack.method_14405(class_3264.field_14188, LOGO)).get();){
                    var6 = new class_10539(class_1011.method_4309((InputStream)inputStream), new class_1084(true, true));
                }
                return var6;
            }
            catch (IOException var18) {
                return class_10539.method_65870();
            }
        }
    }

    public static class ReloadListener
    implements class_4013 {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void method_14491(class_3300 manager) {
            client = class_310.method_1551();
            if (PuzzleConfig.resourcepackSplashScreen) {
                PuzzleSplashScreen.resetColors();
                client.method_1531().method_65876(LOGO, (class_10537)new LogoTexture(LOGO));
                client.method_1531().method_65876(BACKGROUND, (class_10537)new LogoTexture(BACKGROUND));
                manager.method_14488("optifine", path -> path.method_12832().contains("color.properties")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Properties properties = new Properties();
                        properties.load(stream);
                        if (properties.get("screen.loading") != null) {
                            PuzzleConfig.backgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.bar") != null) {
                            PuzzleConfig.progressBarBackgroundColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.bar").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.progress") != null) {
                            PuzzleConfig.progressBarColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.progress").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.outline") != null) {
                            PuzzleConfig.progressFrameColor = MidnightColorUtil.hex2Rgb((String)properties.get("screen.loading.outline").toString()).getRGB();
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        if (properties.get("screen.loading.blend") != null) {
                            PuzzleConfig.disableBlend = properties.get("screen.loading.blend").toString().equals("off");
                            PuzzleConfig.customBlendFunction = new ArrayList<String>(Arrays.stream(properties.get("screen.loading.blend").toString().split(" ")).toList());
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading color.properties {}", (Object)id.toString(), (Object)e);
                    }
                });
                AtomicInteger logoCount = new AtomicInteger();
                manager.method_14488("textures", path -> path.method_12832().contains("mojangstudios.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Files.copy(stream, LOGO_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        client.method_1531().method_65876(LOGO, (class_10537)new DynamicLogoTexture());
                        if (logoCount.get() > 0) {
                            PuzzleConfig.hasCustomSplashScreen = true;
                        }
                        logoCount.getAndIncrement();
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom minecraft logo {}", (Object)id.toString(), (Object)e);
                    }
                });
                manager.method_14488("puzzle", path -> path.method_12832().contains("splash_background.png")).forEach((id, resource) -> {
                    try (InputStream stream = resource.method_14482();){
                        Files.copy(stream, BACKGROUND_TEXTURE, StandardCopyOption.REPLACE_EXISTING);
                        FileInputStream input = new FileInputStream(String.valueOf(BACKGROUND_TEXTURE));
                        client.method_1531().method_4616(BACKGROUND, (class_1044)new class_1043(() -> "splash_screen_background", class_1011.method_4309((InputStream)input)));
                        keepBackground = true;
                        PuzzleConfig.hasCustomSplashScreen = true;
                    }
                    catch (Exception e) {
                        PuzzleCore.LOGGER.error("Error occurred while loading custom splash background {}", (Object)id.toString(), (Object)e);
                    }
                });
                if (!keepBackground) {
                    try {
                        Files.delete(BACKGROUND_TEXTURE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                keepBackground = false;
                PuzzleConfig.write((String)"puzzle");
                PuzzleSplashScreen.buildRenderLayer();
            }
        }
    }
}

