/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VariantsCitMod;
import java.text.Normalizer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public enum EStringTransform implements class_3542
{
    NOOP("noop", Function.identity()),
    LOWERCASE("lowercase", String::toLowerCase),
    SANITIZE("sanitize", s -> EStringTransform.Sanitize(s, "[^a-zA-Z0-9_.-/:]")),
    SANITIZE_PATH("sanitize_path", s -> EStringTransform.Sanitize(s, "[^a-zA-Z0-9_.-/]")),
    SANITIZE_NAMESPACE("sanitize_namespace", s -> EStringTransform.Sanitize(s, "[^a-zA-Z0-9_.-]")),
    DISCARD_NAMESPACE("discard_namespace", s -> {
        int split = s.lastIndexOf(58);
        return split < 0 ? s : s.substring(split + 1);
    }),
    DISCARD_PATH("discard_path", s -> {
        int split = s.lastIndexOf(58);
        return split < 0 ? "" : s.substring(0, split);
    });

    public static final EStringTransform[] EMPTY;
    public static final Codec<EStringTransform> CODEC;
    public static final Codec<EStringTransform[]> ARRAY_CODEC;
    @Deprecated
    public static final Codec<EStringTransform[]> LEGACY_CODEC;
    private final String name;
    private final Function<String, String> lambda;

    private EStringTransform(String name, Function<String, String> lambda) {
        this.name = name;
        this.lambda = lambda;
    }

    private static String Sanitize(String input, String charset) {
        return Normalizer.normalize(input, Normalizer.Form.NFD).replace(' ', '_').toLowerCase().replaceAll(charset, "");
    }

    public static String Transform(EStringTransform[] transforms, String input) {
        for (EStringTransform t : transforms) {
            input = t.Transform(input);
        }
        return input;
    }

    @NotNull
    public String Transform(String nbt) {
        return this.lambda.apply(nbt);
    }

    public String method_15434() {
        return this.name;
    }

    static {
        EMPTY = new EStringTransform[0];
        CODEC = class_3542.method_28140(EStringTransform::values);
        ARRAY_CODEC = CodecUtil.OneOrMany(CODEC).xmap(list -> (EStringTransform[])list.toArray(EStringTransform[]::new), array -> List.of(array));
        LEGACY_CODEC = Codec.BOOL.xmap(lowercase -> {
            EStringTransform[] eStringTransformArray;
            if (lowercase.booleanValue()) {
                EStringTransform[] eStringTransformArray2 = new EStringTransform[1];
                eStringTransformArray = eStringTransformArray2;
                eStringTransformArray2[0] = LOWERCASE;
            } else {
                eStringTransformArray = EMPTY;
            }
            return eStringTransformArray;
        }, transform -> true).validate(_0 -> {
            VariantsCitMod.LOGGER.warn("The parameter `caseSensitive:true` is being deprecated. Use `transform:lowercase` instead.");
            return DataResult.success((Object)_0);
        });
    }
}

