/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.NbtPath;
import java.util.function.Function;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class NbtAdapter {
    public static final MapCodec<NbtAdapter> MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)NbtPath.CODEC.fieldOf("nbtPath").forGetter(adp -> adp.nbtPath), (App)EInput.CODEC.fieldOf("expect").orElse((Object)EInput.PRIMITIVE).forGetter(adp -> adp.type)).apply((Applicative)builder, NbtAdapter::new));
    public static final Codec<NbtAdapter> CODEC = Codec.withAlternative((Codec)MAPCODEC.codec(), (Codec)NbtPath.CODEC.xmap(path -> new NbtAdapter((NbtPath)path, EInput.PRIMITIVE), adp -> adp.nbtPath));
    @Deprecated
    public static final MapCodec<NbtAdapter> LEGACY_MAPCODEC = CodecUtil.MapWithAlternatives(NbtPath.CODEC.fieldOf("nbtPath"), NbtPath.DOT_SEPARATED_CODEC.fieldOf("nbtPath"), NbtPath.NBTKEY_CODEC.fieldOf("nbtKey")).xmap(path -> new NbtAdapter((NbtPath)path, EInput.PRIMITIVE), adp -> adp.nbtPath);
    private final NbtPath nbtPath;
    private final EInput type;

    protected NbtAdapter(NbtPath nbtPath, EInput type) {
        this.nbtPath = nbtPath;
        this.type = type;
    }

    @Nullable
    public final String ResolveData(class_2520 nbt) {
        if ((nbt = this.nbtPath.Resolve(nbt)) == null) {
            return null;
        }
        String data = this.type.Accept(nbt);
        if (data == null) {
            return null;
        }
        return data;
    }

    public static enum EInput implements class_3542
    {
        PRIMITIVE("primitive", nbt -> {
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return string.comp_3831();
            }
            if (nbt instanceof class_2514) {
                class_2514 number = (class_2514)nbt;
                return number.method_10702().toString();
            }
            return null;
        }),
        NUMBER("number", nbt -> {
            String string;
            if (nbt instanceof class_2514) {
                class_2514 number = (class_2514)nbt;
                string = number.method_10702().toString();
            } else {
                string = null;
            }
            return string;
        }),
        STRING("string", nbt -> {
            String string;
            if (nbt instanceof class_2519) {
                class_2519 string2 = (class_2519)nbt;
                string = string2.comp_3831();
            } else {
                string = null;
            }
            return string;
        }),
        IDENTIFIER("identifier", nbt -> {
            String string;
            if (nbt instanceof class_2519) {
                class_2519 string2 = (class_2519)nbt;
                string = class_2960.method_12829((String)string2.comp_3831()).toString();
            } else {
                string = null;
            }
            return string;
        }),
        RICH_TEXT("rich_text", nbt -> {
            DataResult result = class_8824.field_46597.parse((DynamicOps)class_2509.field_11560, nbt);
            if (result.isSuccess()) {
                return ((class_2561)result.getOrThrow()).getString();
            }
            return null;
        });

        public static final Codec<EInput> CODEC;
        private final String name;
        private final Function<class_2520, String> lambda;

        private EInput(String name, Function<class_2520, String> lambda) {
            this.name = name;
            this.lambda = lambda;
        }

        @Nullable
        public String Accept(class_2520 nbt) {
            return this.lambda.apply(nbt);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(EInput::values);
        }
    }
}

