/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ModelAggregator {
    public final Map<class_2960, class_2960> modelsToCreate = new HashMap<class_2960, class_2960>();
    public final Set<class_2960> itemsToCreate = new HashSet<class_2960>();

    public VariantLibrary CreateLibrary(ModuleDefinition definition, class_3300 manager) {
        HashMap<class_2960, class_2960> allVariants = new HashMap<class_2960, class_2960>();
        HashMap<String, class_2960> allSpecials = new HashMap<String, class_2960>();
        String prefix = definition.modelPrefix();
        Optional<class_2960> modelParent = definition.modelParent();
        HashMap<String, class_2960> specials = new HashMap<String, class_2960>(definition.specialModels());
        definition.fallbackModel().ifPresent(fallback -> specials.put((String)null, (class_2960)fallback));
        Map<class_2960, class_2960> varItems = this.FindVariants(manager, "items", prefix, ".json");
        HashMap<String, class_2960> speItems = this.FindSpecials(manager, "items", specials, ".json");
        allVariants.putAll(varItems);
        allSpecials.putAll(speItems);
        if (definition.itemGen()) {
            Map<class_2960, class_2960> varModels = this.FindVariants(manager, "models/item", prefix, ".json");
            HashMap<String, class_2960> speModels = this.FindSpecials(manager, "models/item", specials, ".json");
            allVariants.keySet().forEach(varModels::remove);
            allSpecials.keySet().forEach(speModels::remove);
            allVariants.putAll(varModels);
            allSpecials.putAll(speModels);
            this.itemsToCreate.addAll(varModels.values());
            this.itemsToCreate.addAll(speModels.values());
        }
        if (modelParent.isPresent()) {
            Map<class_2960, class_2960> varTextures = this.FindVariants(manager, "textures/item", prefix, ".png");
            HashMap<String, class_2960> speTextures = this.FindSpecials(manager, "textures/item", specials, ".png");
            allVariants.keySet().forEach(varTextures::remove);
            allSpecials.keySet().forEach(speTextures::remove);
            allVariants.putAll(varTextures);
            allSpecials.putAll(speTextures);
            this.itemsToCreate.addAll(varTextures.values());
            this.itemsToCreate.addAll(speTextures.values());
            varTextures.values().forEach(model -> this.AddModelToCreate((class_2960)model, (class_2960)modelParent.get()));
            speTextures.values().forEach(model -> this.AddModelToCreate((class_2960)model, (class_2960)modelParent.get()));
        }
        allSpecials.remove(null);
        return new VariantLibrary(definition.fallbackModel().orElse(null), allVariants, allSpecials);
    }

    private void AddModelToCreate(class_2960 model, class_2960 parent) {
        if (!this.modelsToCreate.containsKey(model)) {
            this.modelsToCreate.put(model, parent);
        } else if (!this.modelsToCreate.get(model).equals((Object)parent)) {
            VariantsCitMod.LOGGER.error("Conflicting definitions for model {}", (Object)model);
        }
    }

    private Map<class_2960, class_2960> FindVariants(class_3300 manager, String rootDirectory, String modelPrefix, String suffix) {
        HashMap<class_2960, class_2960> results = new HashMap<class_2960, class_2960>();
        String fullPrefix = rootDirectory + "/" + modelPrefix;
        String directory = fullPrefix.substring(0, fullPrefix.lastIndexOf(47));
        for (class_2960 fileId : manager.method_14488(directory, id -> id.method_12832().startsWith(fullPrefix) && id.method_12832().endsWith(suffix)).keySet()) {
            String namespace = fileId.method_12836();
            String assetName = fileId.method_12832();
            assetName = assetName.substring((rootDirectory + "/").length(), assetName.length() - suffix.length());
            String variantName = assetName.substring(modelPrefix.length());
            results.put(class_2960.method_60655((String)namespace, (String)variantName), class_2960.method_60655((String)namespace, (String)assetName));
        }
        return results;
    }

    private HashMap<String, class_2960> FindSpecials(class_3300 manager, String rootDirectory, Map<String, class_2960> requested, String suffix) {
        HashSet<class_2960> valid = new HashSet<class_2960>();
        Map<class_2960, class_2960> resourceIds = requested.values().stream().collect(Collectors.toMap(id -> id.method_45138(rootDirectory + "/").method_48331(suffix), id -> id));
        for (class_2960 fileId : manager.method_14488(rootDirectory, id -> resourceIds.keySet().contains(id)).keySet()) {
            valid.add(resourceIds.get(fileId));
        }
        HashMap<String, class_2960> result = new HashMap<String, class_2960>(requested);
        result.entrySet().removeIf(e -> !valid.contains(e.getValue()));
        return result;
    }
}

